<?php 
/* 
This file is part of HeatMap Theme Pro v5
Copyright: Stuart Wider
Website: HeatMapTheme.com
*/?>
<!DOCTYPE html>
<?php global $themename, $subtitle, $thisversion; ?>
<!--
<?php bloginfo('name')?> uses <?php print $themename . ' ' . $subtitle . ' v' . $thisversion; ?> (http://heatmaptheme.com)
-->
<!-- 
header.php
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

<!--[if IE 6]>
<html id="ie6" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 7]>
<html id="ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html id="ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 6) | !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width" />
<link rel="profile" href="http://gmpg.org/xfn/11" />

<!-- 
HTML Title
~~~ -->

<title><?php 
if( !hmt4_get_option('hmt_seo_plugin'))
{
if (wp_title('',false)) wp_title ('');

$this_site_title = get_bloginfo ('name');
$this_tagline = get_bloginfo ('description');

if ((wp_title('',false)) && ($this_site_title || $this_tagline)) print ' - ';
if ($this_tagline) print $this_tagline;
if ($this_tagline && $this_site_title) print ' - ';
if ($this_site_title) print $this_site_title;

}
else
{
 wp_title();
}
?></title>


<?php // Suggest to search engines that they only index pages, posts and the home page

if (get_option('blog_public', 0)  && ( !hmt4_get_option('hmt_seo_plugin')) ) {

	$this_index_type = hmt4_get_option('hmt_indexing');
	
	if  (($this_index_type == 'Home, Pages and Posts') || ($this_index_type == '')) {
		if (is_home() || is_single() || is_page()) { echo '<meta name="robots" content="index,follow" />'; } else { echo '<meta name="robots" content="noindex,follow" />'; } 
	}
	
	if ($this_index_type == 'Home, Pages, Posts and Categories') {
		if (is_home() || is_single() || is_page() || is_category()) { echo '<meta name="robots" content="index,follow" />'; } else { echo '<meta name="robots" content="noindex,follow" />'; } 
	}
	
	if ($this_index_type == 'Home, Pages, Posts and Tags') {
		if (is_home() || is_single() || is_page() || is_tag()) { echo '<meta name="robots" content="index,follow" />'; } else { echo '<meta name="robots" content="noindex,follow" />'; } 
	}
	
	if ($this_index_type == 'Home, Pages, Posts and Archives') {
		if (is_home() || is_single() || is_page() || is_archive()) { echo '<meta name="robots" content="index,follow" />'; } else { echo '<meta name="robots" content="noindex,follow" />'; } 
	}
	
	if ($this_index_type == 'Index Everything') {
		echo '<meta name="robots" content="index,follow" />';
	}
}

?>

<!-- 
Meta Description and KeyWords for Home Page
~~~ -->

<?php if ( ( is_home() || is_front_page() ) && ( !hmt4_get_option('hmt_seo_plugin'))  ) { 	/* Get the meta information from the options and echo it  - but only for the home page - pages and posts use custom fields to hold this info. */ ?>

	<?php if (hmt4_get_option('hmt_meta_description')): ?> 
		<meta name="description" content="<?php hmt4_echo_option('hmt_meta_description') ?>" />
	<?php endif; ?>

	<?php if (hmt4_get_option('hmt_meta_keywords')): ?> 	
		<meta name="keywords" content="<?php hmt4_echo_option('hmt_meta_keywords') ?>" />
	<?php endif; ?>
<?php } ?>

<!-- 
Meta Description and KeyWords for a Post or a Page
~~~ -->

<?php 
if (( is_single() || is_page() )  && ( ! hmt4_get_option('hmt_seo_plugin')) && ( ! is_front_page()  ) ):	// ...If this is a page or a post, grab the meta information and echo it.
    $temp_post = get_post($post->ID, ARRAY_A);
	if (get_post_meta($post->ID, "meta-description", true)) 
		echo '<meta name="description" content="'. get_post_meta($post->ID, "meta-description", true) . '" />' . "\n";
	if (get_post_meta($post->ID, "meta-keywords", true)) 
		echo '<meta name="keywords" content="'. get_post_meta($post->ID, "meta-keywords", true) . '" />' . "\n";
endif; 
?>

<!--
Favicon
~~~ -->

<?php
if (hmt4_get_option('hmt_favicon_url')) {  /* if there is a favicon url in the options then display the logo and alt text */ ?>
	<link rel="Shortcut Icon" href="<?php hmt4_echo_option('hmt_favicon_url');?>" type="image/x-icon" /> 
<?php
} 
else 									/* otherwise just show the default heatmap favicon */
{ ?> 
	<link rel="Shortcut Icon" href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicon.ico" type="image/x-icon" /> 
<?php
}
?>
<?php
	global $this_header_style;
	$this_header_style = hmt4_get_option('hmt_header_navigation_style');

if( ! isset( $hmt_combo_classes) )
{
$hmt_combo_classes="";
}

	if ($this_header_style == 'Below Header') $hmt_nav_style_class = 'nav-below-header';
	if ($this_header_style == 'Above Header') $hmt_nav_style_class = 'nav-above-header';
	if (($this_header_style == 'Classic') || ($this_header_style == '')) $hmt_nav_style_class = 'nav-classic';
	if ($this_header_style == 'Wide') $hmt_nav_style_class = 'nav-wide';

if (!hmt4_get_option('hmt_squeeze_mode')) { 
	if (($this_header_style == 'Below Header') || ($this_header_style == 'Above Header')) {
		$hmt_combo_classes =  $hmt_combo_classes . 'header-top-or-bot-css' . ' ';
	}
}

if (hmt4_get_option('hmt_squeeze_mode')) { 
	if (($this_header_style == 'Below Header') || ($this_header_style == 'Above Header')) { 
		$hmt_combo_classes =  $hmt_combo_classes . 'header-top-or-bot-squeeze-css' . ' ';
	}
}

if (!hmt4_get_option('hmt_squeeze_mode')) { 
	if (($this_header_style == 'Classic') || ($this_header_style == '')) {
		$hmt_combo_classes =  $hmt_combo_classes . 'header-classic-css' . ' ';	
	}
}

if (hmt4_get_option('hmt_squeeze_mode')) {
	if (($this_header_style == 'Classic') || ($this_header_style == '')) { 
		$hmt_combo_classes =  $hmt_combo_classes . 'header-classic-squeeze-css' . ' ';
	}
}

if  ((hmt4_get_option('hmt_left_or_right')=='LEFT') || (hmt4_get_option('hmt_left_or_right')=='')) { 
	$hmt_lr_class =  'widebar-float-left';
	$hmt_combo_classes =  $hmt_combo_classes . 'switch-css' . ' ';
}
else
{
	$hmt_lr_class =  'widebar-float-right';	
}

if (hmt4_get_option('hmt_squeeze_mode')) {
	$hmt_width_style_class =  'squeeze';
	$hmt_combo_classes =  $hmt_combo_classes . 'squeeze-css' . ' '; 
}
else
{
	$hmt_width_style_class = 'no-squeeze'; 
}
 
if ((hmt4_get_option('hmt_no_sidebars_mode')) && (!hmt4_get_option('hmt_squeeze_mode'))) {
	$hmt_combo_classes =  $hmt_combo_classes . 'no-sidebars-css' . ' '; 	 
}

if ((hmt4_get_option('hmt_no_sidebars_mode')) && (hmt4_get_option('hmt_squeeze_mode'))) { 
	$hmt_combo_classes =  $hmt_combo_classes . 'no-sidebars-squeeze-css' . ' '; 
}

if (hmt4_get_option('hmt_no_sidebars_mode')) {
	$hmt_sidebars_style_class ='no-sidebars';
}
else {
	$hmt_sidebars_style_class ='has-sidebars';
}

$hmt_body_class = $hmt_combo_classes . $hmt_nav_style_class . ' ' . $hmt_lr_class . ' ' . $hmt_width_style_class . ' ' . $hmt_sidebars_style_class;
?>

<!--
RSS Feeds
~~~ -->

<?php if(  wp_count_posts()->publish ) { ?>
<link rel="alternate" type="application/atom+xml" title="<?php bloginfo('name'); ?> Atom Feed" href="<?php bloginfo('atom_url'); ?>" />
<?php 
} 
?>

<!--
Pingback URL
~~~ -->

<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<?php
/*
The dropdown menu code here is based upon 'SuckerFish Dropdowns' and 'Son of Suckerfish' 
by Patrick Griffiths and Dan Webb
http://www.alistapart.com/articles/dropdowns/
http://htmldog.com/articles/suckerfish/dropdowns/

My version expands upon the above by adding support for both categories and pages,
plus page and category exclusion, modifies the CSS specifically to fit 
within the HeatMap Theme framework, and fixes a bug which becomes apparent in Safari 
when you try to generate the UL LI CSS framework using WordPress Functions wp_list_categories
and wp_list_pages.
*/

if (!hmt_is_sidebar_active('nav_bar_pages')): 
	if (!hmt4_get_option('hmt_show_nav_bar'))  /* added option to remove the nav bar javascript - so there are no javascript errors 11/12/09 */
	{
		wp_enqueue_script ('hmtpro5-suckerfish-nav-script', get_template_directory_uri() . '/suckerfish-nav.js');
	}
endif; 

if (!hmt_is_sidebar_active('nav_bar_categories')): 
	if (!hmt4_get_option('hmt_show_cat_bar')) /* added option to remove the cat bar javascript - so there are no javascript errors 11/12/09 */
	{
		wp_enqueue_script ('hmtpro5-suckerfish-cat-script', get_template_directory_uri() . '/suckerfish-cat.js');
	}
endif; 			
?>
<?php 
// threaded comment reply functionality
if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); 
?>
<?php wp_enqueue_script ('hmtpro5-adscript', get_template_directory_uri() . '/adscript.js'); ?>
<?php wp_enqueue_style( 'hmtpro5', get_stylesheet_uri() ); //enqueue style.css ?>
<?php
global $using_ie6;
$using_ie6 = (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE 6.') !== FALSE);

if ($using_ie6)  {
    wp_enqueue_style( 'hmtpro5-ie6', hmt_template_path('ie6.css') ); //enqueue ie6.css
}
?>
<?php wp_enqueue_style( 'hmtpro5-advanced', hmt_template_path('advanced.css') ); //enqueue advanced.css ?>

<!--
wp_head()
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

<?php wp_head(); ?>

<!--
Inline Header Styling
~~~ -->
<?php 
if ( get_theme_mod('header_textcolor') &&  get_theme_mod('header_textcolor')!= 'blank' ) { 

	print '<style type="text/css">';
	print '#header-bar #header-bar-content .blog-title a,';
	print '#header-bar #header-bar-content .blog-title a:visited,';
	print '#header-bar #header-bar-content .blog-tagline a,';
	print '#header-bar #header-bar-content .blog-tagline a:visited {';
	print 'color: #'; print header_textcolor(); print ';';
	print '}';
	print '</style>';			
} 

?>

<!--
Additional Head CSS
~~~ -->

<?php 				
if (hmt4_get_option('hmt_head_css')):			// Any css that you want to pop in the <head> get pulled from the options into here 
	print '<style type="text/css">';
	hmt4_echo_option('hmt_head_css');
	print '</style>';
endif;
?>

<!--
Additional Head Scripts
~~~ -->

<?php 				
if (hmt4_get_option('hmt_head_scripts')):			// Any scripts that you want to pop in the <head> get pulled from the options into here 
	hmt4_echo_option('hmt_head_scripts');
endif;
?>

<!--
End of wp_head()
~~~ -->

</head>

<body <?php body_class($hmt_body_class); ?>>
	<?php 
	global $hmt_seo_text, $have_posts, $temp_post;
	
	if (is_home() || is_front_page() ) {
		$hmt_seo_text = hmt4_get_option('hmt_seo_text');	
	}
	
	if ( ( is_single() || is_page() ) /* && (! is_front_page() ) */) {
		if (have_posts()) {
			the_post(); 
			$temp_post = get_post($post->ID, ARRAY_A);
			$have_posts = true;
			$hmt_seo_text = get_post_meta($post->ID, "seo-text", true);
		}
	}
	?>



    
<!--
The SEO Bar
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

	<?php 
	$this_header_lock = hmt4_get_option('hmt_header_lock');
	?>

	<?php 
	if (hmt4_get_option('hmt_display_header_lock_bar')) {
		if ($hmt_seo_text) {
			if (hmt4_get_option('hmt_header_lock_offset')) {
				if (($this_header_lock == '[Header] Lock Only') ||
					($this_header_lock == 'All Header Bars')) { 
						if (!$using_ie6) {?>
							<div id="header-lock-spacer" style="height:<?php hmt4_echo_option('hmt_header_lock_offset'); ?>px;">&nbsp;</div>
					<?php
						}
				}
			}
		}
	}
	?>

	<?php 
    if ($hmt_seo_text) {
    ?>
    
        <div id="seo-text-bar">
            
            	<?php print $hmt_seo_text; ?>
            
        </div> <!-- id="seo-bar" -->
            
        <div class="clearFloat"></div>
    
    <?php 
	}
    ?>
    
	<?php 
	if (!$hmt_seo_text) {
		if (($this_header_lock == '[Header] Lock Only') ||
			($this_header_lock == 'All Header Bars')) { 
				if (!$using_ie6) {?>
					<div id="header-lock-spacer" style="height:<?php hmt4_echo_option('hmt_header_lock_offset'); ?>px;">&nbsp;</div>
		<?php
				}
		}
	}
	?>
        
<!--
[Header] Lock Bar
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

	<?php 
	if (($this_header_lock =='[Header] Lock Only') ||
	 	($this_header_lock == 'All Header Bars')) { ?>
			<div id="header-lock-wrapper">
	<?php
    }
	?>
    
    <?php 
	if (hmt4_get_option('hmt_display_header_lock_bar')) {
	?>
    
        <div id="header-lock">
        
            <?php
            if (hmt_is_sidebar_active('header_lock')) {
            ?>	
                    <span class="header-lock-widget-block">
                        <?php dynamic_sidebar('header_lock'); ?>
                    </span>
            <?php
            }
            ?>
    
        </div> <!-- id="header-lock" -->
      
	<?php
    }
	?> 
     
            
	<?php 
    if ($this_header_lock=='[Header] Lock Only') { ?>
         </div> <!-- id="header-lock-wrapper" -->
    <?php
    }
    ?>
    
    <div class="clearFloat"></div>

	<?php 
	if ($this_header_style == 'Wide') {
		get_template_part ('theme-nav','page');
		get_template_part ('theme-nav', 'cat');	
	}
	?>
                  
<!--
[Sub Header] Lock Bar
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

	<?php 
    if (hmt4_get_option('hmt_display_sub_header_lock_bar')) {
    ?>

        <div id="sub-header-lock">
    
            <?php
            if (hmt_is_sidebar_active('sub_header_lock')) {
            ?>	
                    <span class="sub-header-lock-widget-block">
                        <?php dynamic_sidebar('sub_header_lock'); ?>
                    </span>
            <?php
            }
            ?>

        </div> <!-- id="sub-header-lock" -->  
    
    <div class="clearFloat"></div>  
    
    <?php
    }
    ?>
    
           
    <?php 
    if ($this_header_lock == 'All Header Bars') { ?>
     </div> <!-- id="header-lock-wrapper" -->
    <?php
    }
    ?>
    

    <div class="clearFloat"></div>      
        
               
<!--
The High Bar
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

	<?php 
    if (hmt_is_sidebar_active('sidebar-5')):
    ?> 

        <div id="high-bar">
        
        
                
                <span class="high-bar-widget-block">
                	<?php dynamic_sidebar('sidebar-5'); ?>
                </span>
            
            
        </div> <!-- id="high-bar" -->
            
        <div class="clearFloat"></div>
    
    <?php 
    endif;
    ?>


    <?php 
	if ($this_header_style == 'Above Header') {
		if ((!hmt4_get_option('hmt_show_cat_bar')) || (!hmt4_get_option('hmt_show_nav_bar'))) {
		?>
    	<div class="clearFloat-spacer-10">&nbsp;</div>
    	<?php
		}
		get_template_part ('theme-nav','page');
		get_template_part ('theme-nav', 'cat');	
		?>	
<!--
Header Mid
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->        
		<?php
		if (hmt_is_sidebar_active('header_mid')):
		?>
	
			<div id="header-mid-above">
				
				<span class="header-mid-widget-block">
					<?php dynamic_sidebar('header_mid'); ?>
				</span>
				
			</div> <!-- id="header-mid-above" -->
				
			<div class="clearFloat"></div>
		
		<?php 
		endif;
	}
	?>
	
<!--
The Header Bar
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->
	<?php
	$this_class = '';
	
	if (!hmt4_get_option('hmt_hide_header')): ?>
	<div id="header-bar"<?php  if (get_header_image()) { ?> style="background-image: url(<?php header_image(); ?>);"<?php } ?> <?php print $this_class; ?>> <?php /* this is important - dont delete it */ ?>
	
<!--
The Logo
~~~ -->
  	
		<?php 

        if (hmt4_get_option('hmt_logo_url')) {  /* if there is a logo url in the options then  display the logo and alt text */ ?>
            <div id="header-bar-logo">
                <a href="<?php echo home_url(); ?>/"><img src="<?php hmt4_echo_option('hmt_logo_url'); ?>" alt="<?php hmt4_echo_option('hmt_alt_text'); ?>" /></a>
            </div> <!-- id="header-bar-logo" -->
        <?php
            
        } ?>
					
<!--
The Name of the Blog and the Tagline
~~~ -->
			
		<?php 
		if ( (!hmt4_get_option('hmt_show_title_and_tagline')) && (get_theme_mod('header_textcolor')!= 'blank' ) ) {  /* alternatively, if you want the title and tag line you can show that too */ ?>

			<?php
			global $h1_setting;
			$h1_setting = hmt4_get_option('hmt_h1_setting');
			
			if (($h1_setting == "SITE TITLE") && (is_home() || is_front_page() )) { 
			?>
				<div id="header-bar-content">
					<h1 class="blog-title smaller-h1-site-title"><a href="<?php echo home_url(); ?>/"><?php bloginfo('name'); ?></a></h1>
					<div class="blog-tagline"><a href="<?php echo home_url(); ?>/"><?php bloginfo('description'); ?></a></div>
				</div> <!-- id="header-bar-content" -->
			<?php
			}
			elseif (($h1_setting == "TAGLINE") && (is_home() || is_front_page() ) ) { 
			?>    
				<div id="header-bar-content">
					<div class="blog-title"><a href="<?php echo home_url() ; ?>/"><?php bloginfo('name'); ?></a></div>
					<h1 class="blog-tagline smaller-h1-tagline"><a href="<?php echo home_url(); ?>/"><?php bloginfo('description'); ?></a></h1>
				</div> <!-- id="header-bar-content" -->
			<?php
			}
			else {
			?>
				<div id="header-bar-content">
					<div class="blog-title"><a href="<?php echo home_url(); ?>/"><?php bloginfo('name'); ?></a></div>
					<div class="blog-tagline"><a href="<?php echo home_url(); ?>/"><?php bloginfo('description'); ?></a></div>
				</div> <!-- id="header-bar-content" -->
			<?php
			}

		}
        ?>
            
<!--
Widget Area: Header Right
~~~ -->
			
		<?php 
        if (hmt_is_sidebar_active('sidebar-6')):
        ?> 

        <div id="header-bar-right">
            

            
            <?php dynamic_sidebar('sidebar-6'); ?>
                
        </div> <!-- id="header-bar-right" -->
        
        <?php
        endif;
        ?>
				
                
    </div> <!-- id="header-bar" -->
        
    <div class="clearFloat"></div>
    <?php
	endif;
	?>
    
    <?php 
	if ($this_header_style == 'Below Header') {
		if ((!hmt4_get_option('hmt_show_cat_bar')) || (!hmt4_get_option('hmt_show_nav_bar'))) {
		?>
    		<div class="clearFloat-spacer-10">&nbsp;</div>
    	<?php
		}
		?>	
        
<!--
Header Mid
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ --> 

		<?php
		if (hmt_is_sidebar_active('header_mid')):
		?>
	
			<div id="header-mid-below">
				
				<span class="header-mid-widget-block">
					<?php dynamic_sidebar('header_mid'); ?>
				</span>
				
			</div> <!-- id="header-mid-below" -->
				
			<div class="clearFloat"></div>
		
		<?php 
		endif;
		
        get_template_part ('theme-nav','page');
		get_template_part ('theme-nav', 'cat');	
	}
	?>
    
     <?php 
	if (($this_header_style == 'Classic') || ($this_header_style == '')) {
		
		if (hmt_is_sidebar_active('header_mid')):
		?>
	
			<div id="header-mid-classic">
				
				<span class="header-mid-widget-block">
					<?php dynamic_sidebar('header_mid'); ?>
				</span>
				
			</div> <!-- id="header-mid-classic" -->
				
			<div class="clearFloat"></div>
		
		<?php 
		endif;		
		
        get_template_part ('theme-nav','page');
		get_template_part ('theme-nav', 'cat');	
	}
	?>
       
<!--
[Header] Low
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

	<?php 
    if (hmt_is_sidebar_active('header_low')):
    ?>

        <div id="header-low">
            
            <span class="header-low-widget-block">
            	<?php dynamic_sidebar('header_low'); ?>
            </span>
            
        </div> <!-- id="header-low" -->
            
        <div class="clearFloat"></div>
    
    <?php 
    endif;
    ?>
   
    <div id="main">
                        
        <?php 
        /* reset widgets - when you visit the page again the ad widgets will show */
        $ads_already_shown = FALSE; 
        $all_content_above_already_shown = FALSE;
        ?>
     	
<!--
End of header.php
~~~ -->