<?php
/* ImportBuddy Restore & Migration Tool - iThemes.com
 * @author Dustin Bolton
 *
 * ATTENTION: IF YOU ARE READING THIS WHILE TRYING TO LOAD IMPORTBUDDY TO RESTORE YOUR SITE:
 * Your server is not properly handling PHP files. Contact your hosting provider to fix this.
 * Notify them that PHP files are not executing and instead are outputting their code contents.
 *
 */

$php_minimum = '5.1'; // User's PHP must be equal or newer to this version.
$ignore_not_writable = false; // Set to true to ignore is_writable() returning false on this directory. Useful for servers lying about the writable status of the directory.
//error_reporting( E_ALL );

if ( version_compare( PHP_VERSION, $php_minimum ) < 0 ) {
	die( 'ERROR #9013. See <a href="http://ithemes.com/codex/page/BackupBuddy:_Error_Codes#9013">this codex page for details</a>. Sorry! PHP version ' . $php_minimum . ' or newer is required for BackupBuddy to properly run. You are running PHP version ' . PHP_VERSION . '.' );
}

global $importbuddy_file;
$importbuddy_file = basename( __FILE__ ); // filename of importbuddy.php (or whatever it is named).

global $wp_version;
$wp_version = '4.4'; // Spoof a version for new wp-db class.

$abspath = rtrim( dirname( __FILE__ ), '\\/' ) . '/';
define( 'ABSPATH', $abspath );
define( 'WP_CONTENT_DIR', $abspath . 'wp-content' );
define( 'PB_BB_VERSION', '7.1.3.1 (downloaded 2016-05-30T07:25:13+00:00)' );
define( 'PB_PASSWORD', 'f00bdfd475bb4661c50caee90be7873d' );

// Used by wpdb class.
define('DB_CHARSET', 'utf8'); // Default only. Overriden later if needed.
define('DB_COLLATE', ''); // Default only. Overriden alter if needed.

@date_default_timezone_set( @date_default_timezone_get() ); // Prevents date() from throwing a warning if the default timezone has not been set. Run prior to any file_exists()!


// Try to put an index.htm file in place during import to help prevent against file browsing. Only do if not a defined step OR a non-numeric defined step OR a defined numeric step < 5.
if (
	( ! isset( $_GET['step'] ) )
	||
	( isset( $_GET['step'] ) && !is_numeric( $_GET['step'] ) )
	||
	( isset( $_GET['step'] ) && is_numeric( $_GET['step'] ) && ( $_GET['step'] < 5 ) )
	)
{
	if ( ( ! file_exists( ABSPATH . 'index.htm' ) ) && ( ! file_exists( ABSPATH . 'index.php' ) ) ) {
		@file_put_contents( ABSPATH . 'index.htm', '<html></html>' );
	}
}


// If inside BB install then die. Else unpack importbuddy if needed.
if ( @file_exists( @dirname( @dirname( __FILE__ ) ) . '/backupbuddy.php' ) ) {
	
	die( '<html>Access Denied</html>' );
	
}


// Unpack importbuddy files into importbuddy directory. Does this when importbuddy directory does not exist OR if now request GET or POST params are sent (aka the first page only).
if ( ! file_exists( ABSPATH . 'importbuddy' ) || ( ( count( $_GET ) == 0 ) && ( count( $_POST ) == 0 ) ) ) {
	
	// Make sure this file is complete and contains all the packed data to the end before proceeding.
	if ( false === strpos( file_get_contents( __FILE__ ), '###PACKDATA' . ',END' ) ) { // Concat here so we don't false positive on this line when searching.
		die( 'ERROR: It appears your `' . __FILE__ . '` file is incomplete.  It may have not finished downloading or uploading completely.  Please try re-downloading the script from within BackupBuddy in WordPress (do not just copy the file from the plugin directory) and re-uploading it.' );
	}
	
	$unpack_importbuddy = true;
	if ( file_exists( ABSPATH . 'importbuddy' ) ) { // ImportBuddy directory already exists. We may need to re-unpack it if this file has been updated since.
		$signature = @file_get_contents( ABSPATH . 'importbuddy/_signature.php' );
		$signature = trim( str_replace( '<?php die(); ?>', '', $signature ) );
		if ( md5( PB_BB_VERSION . PB_PASSWORD ) != $signature ) { // Signature mismatch. We will need to delete and unpack again to update.
			//echo '<!-- unlinking existing importbuddy directory. -->'; 5.1.0.10: Broke causing headers already sent error due to auth.
			recursive_unlink( ABSPATH . 'importbuddy' );
		} else {
			$unpack_importbuddy = false;
		}
	}
	if ( true === $unpack_importbuddy ) {
		unpack_importbuddy( $ignore_not_writable );
		@file_put_contents( ABSPATH . 'importbuddy/_signature.php', '<?php die(); ?>' . md5( PB_BB_VERSION . PB_PASSWORD ) ); // Create a hash of this ImportBuddy version & password. On accessing importbuddy.php's authentication page all importbuddy files will be freshly unpacked if the importbuddy.php version and/or password mismatches to allow users to just replace importbuddy.php to upgrade ImportBuddy or password.
	}
}


// Database wrapper.
require_once( ABSPATH . 'importbuddy/classes/wp-db.php' );
global $wpdb;
//$wpdb = new wpdb();



if ( isset( $_GET['api'] ) && ( $_GET['api'] != '' ) ) { // API ACCESS
	if ( $_GET['api'] == 'ping' ) {
		die( 'pong' );
	} else {
		die( 'Unknown API access action.' );
	}
} else { // NORMAL ACCESS.
	if ( !file_exists( ABSPATH . 'importbuddy/init.php' ) ) {
		die( 'Error: Unable to find file `' . ABSPATH . 'importbuddy/init.php`. Make sure that you downloaded this script from within BackupBuddy. Copying importbuddy files from inside the plugin directory is not sufficient as many file additions are made on demand.' );
	} else {
		require_once( ABSPATH . 'importbuddy/init.php' );
	}
}



function recursive_unlink( $path ) {
  return is_file($path)?
    @unlink($path):
array_map('recursive_unlink',glob($path.'/*'))==@rmdir($path);
}


/**
*	unpack_importbuddy()
*
*	Unpacks required files encoded in importbuddy.php into stand-alone files.
*
*	@return		null
*/
function unpack_importbuddy( $ignore_not_writable = false ) {
	if ( ( ! is_writable( ABSPATH ) ) && ( false === $ignore_not_writable ) ) {
		echo 'Error #224834. This directory, `' . ABSPATH . '`, is not write enabled according to the server. Please verify proper write permissions to continue. If this persists, contact your web hosting provider and tell them that is_writable("' . ABSPATH . '") returns FALSE in PHP.';
		die();
	} else {
		$unpack_file = '';
		
		$handle = @fopen( __FILE__, 'r' );
		if ( $handle ) {
			while ( ( $buffer = fgets( $handle ) ) !== false ) {
				if ( substr( $buffer, 0, 11 ) == '###PACKDATA' ) {
					$packdata_commands = explode( ',', trim( $buffer ) );
					array_shift( $packdata_commands );
					
					if ( $packdata_commands[0] == 'BEGIN' ) {
						// Start packed data.
					} elseif ( $packdata_commands[0] == 'FILE_START' ) {
						$unpack_file = $packdata_commands[2];
					} elseif ( $packdata_commands[0] == 'FILE_END' ) {
						$unpack_file = '';
					} elseif ( $packdata_commands[0] == 'END' ) {
						return;
					}
				} else {
					if ( $unpack_file != '' ) {
						if ( !is_dir( dirname( ABSPATH . $unpack_file ) ) ) {
							$mkdir_result = mkdir( dirname( ABSPATH . $unpack_file ), 0777, true ); // second param makes recursive.
							if ( $mkdir_result === false ) {
								echo 'Error #54455. Unable to mkdir `' . dirname( ABSPATH . $unpack_file ) . '`<br>';
							}
						}
						$fileput_result = file_put_contents( ABSPATH . $unpack_file, base64_decode( $buffer ) );
						if ( $fileput_result === false ) {
							echo 'Error #65656. Unable to put file contents to `' . ABSPATH . $unpack_file . '`.<br>';
						}
					}
				}
			}
			if ( !feof( $handle ) ) {
				echo "Error: unexpected fgets() fail.<br>";
			}
			fclose( $handle );
		} else {
			echo 'ERROR #54455: Unable to open `' . __FILE__ . '` file for reading in packaged data.<br>';
		}
	}
}
die();
?>
<?php /*
###PACKDATA,BEGIN
###PACKDATA,FILE_START,/_importbuddy/importbuddy/.htaccess,importbuddy/.htaccess

###PACKDATA,FILE_END,/_importbuddy/importbuddy/.htaccess,importbuddy/.htaccess
###PACKDATA,FILE_START,/_importbuddy/importbuddy/index.htm,importbuddy/index.htm
PGh0bWw+PC9odG1sPg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/index.htm,importbuddy/index.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/index.html,importbuddy/index.html
PGh0bWw+PC9odG1sPg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/index.html,importbuddy/index.html
###PACKDATA,FILE_START,/_importbuddy/importbuddy/index.php,importbuddy/index.php
PD9waHAKLy8gU2lsZW5jZSBpcyBnb2xkZW4uCj8+
###PACKDATA,FILE_END,/_importbuddy/importbuddy/index.php,importbuddy/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/init.php,importbuddy/init.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/init.php,importbuddy/init.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/init_admin.php,importbuddy/init_admin.php
PD9waHAKcGJfYmFja3VwYnVkZHk6OmxvYWQoKTsKCi8vICoqKioqKioqKiogQUNUSU9OUyAoYWRtaW4pICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBBSkFYIChhZG1pbikgKioqKioqKioqKgoKCgovLyAqKioqKioqKioqIERBU0hCT0FSRCAoYWRtaW4pICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBGSUxURVJTIChhZG1pbikgKioqKioqKioqKgoKCgovLyAqKioqKioqKioqIFBBR0VTIChhZG1pbikgKioqKioqKioqKgoKCgovLyAqKioqKioqKioqIExJQlJBUklFUyAmIENMQVNTRVMgKGFkbWluKSAqKioqKioqKioqCnJlcXVpcmVfb25jZSggJ2NsYXNzZXMvY29yZS5waHAnICk7CgpyZXF1aXJlX29uY2UoICdjbGFzc2VzL2ltcG9ydC5waHAnICk7CnBiX2JhY2t1cGJ1ZGR5OjokY2xhc3Nlc1snaW1wb3J0J10gPSBuZXcgcGJfYmFja3VwYnVkZHlfaW1wb3J0KCk7CgoKLy8gKioqKioqKioqKiBPVEhFUiAoYWRtaW4pICoqKioqKioqKioKCgoKPz4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/init_admin.php,importbuddy/init_admin.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/init_global.php,importbuddy/init_global.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/init_global.php,importbuddy/init_global.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/init_public.php,importbuddy/init_public.php
PD9waHAKCgoKLy8gKioqKioqKioqKiBBQ1RJT05TIChwdWJsaWMpICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBBSkFYIChwdWJsaWMpICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBGSUxURVJTIChwdWJsaWMpICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBTSE9SVENPREVTIChwdWJsaWMpICoqKioqKioqKioKCgoKPz4K
###PACKDATA,FILE_END,/_importbuddy/importbuddy/init_public.php,importbuddy/init_public.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/license.txt,importbuddy/license.txt
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/license.txt,importbuddy/license.txt
###PACKDATA,FILE_START,/_importbuddy/importbuddy/readme.txt,importbuddy/readme.txt
ICogV2Vic2l0ZTogaHR0cDovL2l0aGVtZXMuY29tCiAqCiAqIEluc3RhbGxhdGlvbjoKICogCiAqIDEuIERvd25sb2FkIGFuZCB1bnppcCB0aGUgbGF0ZXN0IHJlbGVhc2UgemlwIGZpbGUKICogMi4gSWYgeW91IHVzZSB0aGUgV29yZFByZXNzIHBsdWdpbiB1cGxvYWRlciB0byBpbnN0YWxsIHRoaXMgcGx1Z2luIHNraXAgdG8gc3RlcCA0LgogKiAzLiBVcGxvYWQgdGhlIGVudGlyZSBwbHVnaW4gZGlyZWN0b3J5IHRvIHlvdXIgYC93cC1jb250ZW50L3BsdWdpbnMvYCBkaXJlY3RvcnkKICogNC4gQWN0aXZhdGUgdGhlIHBsdWdpbiB0aHJvdWdoIHRoZSAnUGx1Z2lucycgbWVudSBpbiBXb3JkUHJlc3MgQWRtaW5pc3RyYXRpb24KICogCiAqIFVzYWdlOgogKiAKICogMS4gTmF2aWdhdGUgdG8gdGhlIG5ldyBtZW51IGZvciB0aGlzIHBsdWdpbiBpbiB0aGUgV29yZHByZXNzIEFkbWluaXN0cmF0aW9uIFBhbmVsCiAqIDIuIFNlbGVjdCAnR2V0dGluZyBTdGFydGVkJyBmb3IgaW5zdHJ1Y3Rpb25zIGFuZCBhZGRpdGlvbmFsIGluZm9ybWF0aW9uLgogKg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/readme.txt,importbuddy/readme.txt
###PACKDATA,FILE_START,/_importbuddy/importbuddy/sample.ini,importbuddy/sample.ini
OyBEZWZhdWx0IHZhbHVlcyBjYW4gYmUgc2VlbiBpbjogaW1wb3J0YnVkZHkvY2xhc3Nlcy9yZXN0b3JlLnBocCAob3IgYmFja3VwYnVkZHkvY2xhc3Nlcy9yZXN0b3JlLnBocCkgaW4gdGhlIF9fY29uc3RydWN0KCkgZnVuY3Rpb24sIHdoZXJlICR0aGlzLT5fc3RhdGUgaXMgZmlyc3Qgc2V0LgoKdHlwZSA9IHJlc3RvcmUKYXJjaGl2ZSA9IGJhY2t1cC1iYWNrdXBidWRkeS1YWFhYWFhYWFhYWC56aXAKc2l0ZXVybCA9IGh0dHA6Ly9maW5hbHVybC5jb20KaG9tZXVybCA9IGh0dHA6Ly9maW5hbHVybC5jb20KcmVzdG9yZUZpbGVzID0gdHJ1ZQpyZXN0b3JlRGF0YWJhc2UgPSB0cnVlCm1pZ3JhdGVIdGFjY2VzcyA9IHRydWUKCjsgQm90aCBvZiB0aGVzZSBtdXN0IGJlIHRydWUgd2hlbiB1c2luZyAuaW5pIGZpbGUuCmluaW1vZGUgPSB0cnVlCmF1dG9BZHZhbmNlID0gdHJ1ZQoKW2RhdGFiYXNlU2V0dGluZ3NdCnNlcnZlciA9IGxvY2FsaG9zdApkYXRhYmFzZSA9IGRhdGFiYXNlX25hbWUKdXNlcm5hbWUgPSBkYXRhYmFzZV91c2VyCnBhc3N3b3JkID0gZGF0YWJhc2VfcGFzc3dvcmQKcHJlZml4ID0gd3BfCnJlbmFtZVByZWZpeCA9IHRydWUKd2lwZVByZWZpeCA9IGZhbHNlCndpcGVEYXRhYmFzZSA9IGZhbHNlCgpbY2xlYW51cF0KZGVsZXRlQXJjaGl2ZSA9IGZhbHNlCmRlbGV0ZVRlbXBGaWxlcyA9IHRydWUKZGVsZXRlSW1wb3J0QnVkZHkgPSBmYWxzZQpkZWxldGVJbXBvcnRMb2cgPSB0cnVl
###PACKDATA,FILE_END,/_importbuddy/importbuddy/sample.ini,importbuddy/sample.ini
###PACKDATA,FILE_START,/_importbuddy/importbuddy/classes/auth.php,importbuddy/classes/auth.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/classes/auth.php,importbuddy/classes/auth.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/classes/index.php,importbuddy/classes/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/classes/index.php,importbuddy/classes/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/classes/test-db.php,importbuddy/classes/test-db.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/classes/test-db.php,importbuddy/classes/test-db.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/classes/wp-db.php,importbuddy/classes/wp-db.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/classes/wp-db.php,importbuddy/classes/wp-db.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax.php,importbuddy/controllers/ajax.php
PD9waHAKY2xhc3MgcGJfYmFja3VwYnVkZHlfYWpheCBleHRlbmRzIHBiX2JhY2t1cGJ1ZGR5X2FqYXhjb3JlIHsKfQo/Pg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax.php,importbuddy/controllers/ajax.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/index.php,importbuddy/controllers/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/index.php,importbuddy/controllers/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/css/index.php,importbuddy/css/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/css/index.php,importbuddy/css/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/css/nprogress.css,importbuddy/css/nprogress.css
LyogTWFrZSBjbGlja3MgcGFzcy10aHJvdWdoICovCiNucHJvZ3Jlc3MgewogIHBvaW50ZXItZXZlbnRzOiBub25lOwp9CgojbnByb2dyZXNzIC5iYXIgewogIGJhY2tncm91bmQ6ICMyOWQ7CgogIHBvc2l0aW9uOiBmaXhlZDsKICB6LWluZGV4OiA3NTsKICB0b3A6IDQ4cHg7CiAgbGVmdDogMDsKCiAgd2lkdGg6IDEwMCU7CiAgaGVpZ2h0OiA0cHg7Cn0KCi8qIEZhbmN5IGJsdXIgZWZmZWN0ICovCiNucHJvZ3Jlc3MgLnBlZyB7Cgp9CgovKiBSZW1vdmUgdGhlc2UgdG8gZ2V0IHJpZCBvZiB0aGUgc3Bpbm5lciAqLwojbnByb2dyZXNzIC5zcGlubmVyIHsKICBkaXNwbGF5OiBibG9jazsKICBwb3NpdGlvbjogZml4ZWQ7CiAgei1pbmRleDogMTAzMTsKICB0b3A6IDY1cHg7CiAgcmlnaHQ6IDE1cHg7Cn0KCiNucHJvZ3Jlc3MgLnNwaW5uZXItaWNvbiB7CiAgd2lkdGg6IDQwcHg7CiAgaGVpZ2h0OiA0MHB4OwogIGJveC1zaXppbmc6IGJvcmRlci1ib3g7CgogIGJvcmRlcjogc29saWQgNHB4IHRyYW5zcGFyZW50OwogIGJvcmRlci10b3AtY29sb3I6ICMyOWQ7CiAgYm9yZGVyLWxlZnQtY29sb3I6ICMyOWQ7CiAgYm9yZGVyLXJhZGl1czogNTAlOwoKICAtd2Via2l0LWFuaW1hdGlvbjogbnByb2dyZXNzLXNwaW5uZXIgNDAwbXMgbGluZWFyIGluZmluaXRlOwogICAgICAgICAgYW5pbWF0aW9uOiBucHJvZ3Jlc3Mtc3Bpbm5lciA0MDBtcyBsaW5lYXIgaW5maW5pdGU7Cn0KCkAtd2Via2l0LWtleWZyYW1lcyBucHJvZ3Jlc3Mtc3Bpbm5lciB7CiAgMCUgICB7IC13ZWJraXQtdHJhbnNmb3JtOiByb3RhdGUoMGRlZyk7IH0KICAxMDAlIHsgLXdlYmtpdC10cmFuc2Zvcm06IHJvdGF0ZSgzNjBkZWcpOyB9Cn0KQGtleWZyYW1lcyBucHJvZ3Jlc3Mtc3Bpbm5lciB7CiAgMCUgICB7IHRyYW5zZm9ybTogcm90YXRlKDBkZWcpOyB9CiAgMTAwJSB7IHRyYW5zZm9ybTogcm90YXRlKDM2MGRlZyk7IH0KfQo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/css/nprogress.css,importbuddy/css/nprogress.css
###PACKDATA,FILE_START,/_importbuddy/importbuddy/css/style.css,importbuddy/css/style.css
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/css/style.css,importbuddy/css/style.css
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/bb-logo.png,importbuddy/images/bb-logo.png
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/bb-logo.png,importbuddy/images/bb-logo.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/bluebutton.jpg,importbuddy/images/bluebutton.jpg
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/bluebutton.jpg,importbuddy/images/bluebutton.jpg
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/bullet_error.png,importbuddy/images/bullet_error.png
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAhlJREFUeNrEk7tuE0EUhv/ZC7aBOJItItkoOGBjJSkR4REsFyBEkVQUEBcoDQ0SJQ15ApooRVJQJi+AoKFDSCCiiODEBmyMkIXiS3bjy3pn5gyzhgY2XQr+0ezsnjn7aeb8M0wphdPIwCllBQ/1pAQWoJiRBNGiMuxl2HZeKQk5HFao720S8e3RcNj2PR9Tz1/9DfijGXBa45OJIkulYQoPjOmoGV2gem1B/mzc1l8rutdP2kJCCVrnqemilcvBdA7BJpNg8SSsbhPR2TmwS/kiSVoPckMA8vmSP5EoWOkU8Ok95Oc94OY94NZ9+OUyxM47xKYzYMl0QXKxFAJI0ygZqYtA8zvE0RGUGfk9Gzik32WrDfGtjlgmC2kYpRBAmeasFbUhfjR0IW0QJx2kcYIcCZCO+bUaDDs6zg25IIWEkgTF9ah/VkIHR6PAFQ1Tek73oEntis4JAfhxb9/s+deNC2mISgWKWZDPVmFwoRkGRH+AM9mr4EMPfq+3H9qC7zgbg+oBWGoGiMYhXBfmo6dgj1fhtVzgXBxm5jK65R34x85GaAUE2hrUq3dwNlY4f+0GWO0LnIclXUNCZG4e9pUcOge76FZ2X+rlbYUAWh1J8kH3w9s177BVnMjOI5KYGpvAJUfzzWs41Y8vdLVWmGF1TgIEqhOJu25lb9FtfF1mlpVXROOj7PfdTQ3b1uVo/3sX2H+/jb8EGAB6SgK2ePksLgAAAABJRU5ErkJggg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/bullet_error.png,importbuddy/images/bullet_error.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/button-grad.png,importbuddy/images/button-grad.png
iVBORw0KGgoAAAANSUhEUgAAAAUAAAAeCAYAAADkftS9AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAACF0RVh0U29mdHdhcmUATWFjcm9tZWRpYSBGaXJld29ya3MgNC4w6iYndQAAABZ0RVh0Q3JlYXRpb24gVGltZQAxMS8xNy8wONpsdXEAAABGSURBVHicY9Ts2fWfAQ2wMPzHEGNg+f//H6Ygwz9sgthU/sdmJlbtlFpEgpOwWoTszv+Dz0lUtOg/ukoSfATT+5+gSkxBAOqCS3dTeDKPAAAAAElFTkSuQmCC
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/button-grad.png,importbuddy/images/button-grad.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/collapsed.gif,importbuddy/images/collapsed.gif
R0lGODlhBgAHALMKAM7Ozr6+vq6urp6enoWFhaampt7e3u/v742NjX19ff///wAAAAAAAAAAAAAAAAAAACH5BAEAAAoALAAAAAAGAAcAAAQVEAFFVUrD0HvF4RfCEYGVFAeFaFUEADs=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/collapsed.gif,importbuddy/images/collapsed.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/expanded.gif,importbuddy/images/expanded.gif
R0lGODlhBwAGALMKAM7Ozr6+vq6urp6enoWFhaampt7e3u/v742NjX19ff///wAAAAAAAAAAAAAAAAAAACH5BAEAAAoALAAAAAAHAAYAAAQWEKU5kaETqEKHUgcxGZ8SJEL5IccXAQA7
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/expanded.gif,importbuddy/images/expanded.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/gray-grad.png,importbuddy/images/gray-grad.png
iVBORw0KGgoAAAANSUhEUgAAAAUAAAAfCAIAAACgQJBPAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAAAsSAAALEgHS3X78AAAAIXRFWHRTb2Z0d2FyZQBNYWNyb21lZGlhIEZpcmV3b3JrcyA0LjDqJid1AAAAFnRFWHRDcmVhdGlvbiBUaW1lADEwLzI0LzA4KQ6r+wAAAClJREFUeJxjfPv2LQMSYPn//z8yn4kBFaDzqa0eXZ5U9QMtT6l5tFYPADsXLPcJwrwLAAAAAElFTkSuQmCC
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/gray-grad.png,importbuddy/images/gray-grad.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/icon_16x16.png,importbuddy/images/icon_16x16.png
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/icon_16x16.png,importbuddy/images/icon_16x16.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/icon_32x32.png,importbuddy/images/icon_32x32.png
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/icon_32x32.png,importbuddy/images/icon_32x32.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/index.php,importbuddy/images/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/index.php,importbuddy/images/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/loading.gif,importbuddy/images/loading.gif
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/loading.gif,importbuddy/images/loading.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/loading_large.gif,importbuddy/images/loading_large.gif
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/loading_large.gif,importbuddy/images/loading_large.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/pb-logo.png,importbuddy/images/pb-logo.png
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/pb-logo.png,importbuddy/images/pb-logo.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/white-grad.png,importbuddy/images/white-grad.png
iVBORw0KGgoAAAANSUhEUgAAAAUAAAAeCAYAAADkftS9AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAACF0RVh0U29mdHdhcmUATWFjcm9tZWRpYSBGaXJld29ya3MgNC4w6iYndQAAABZ0RVh0Q3JlYXRpb24gVGltZQAxMS8xNy8wONpsdXEAAAAlSURBVHicY/z///9/BjTAhC7AwMDAwIJFIXbBoaJ9qLhz+IUSAIMMOibeSzRBAAAAAElFTkSuQmCC
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/white-grad.png,importbuddy/images/white-grad.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/ejs.js,importbuddy/js/ejs.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/ejs.js,importbuddy/js/ejs.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/importbuddy.js,importbuddy/js/importbuddy.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/importbuddy.js,importbuddy/js/importbuddy.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/index.php,importbuddy/js/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/index.php,importbuddy/js/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/jquery.js,importbuddy/js/jquery.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/jquery.js,importbuddy/js/jquery.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/jquery.leanModal.min.js,importbuddy/js/jquery.leanModal.min.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/jquery.leanModal.min.js,importbuddy/js/jquery.leanModal.min.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/jquery.simple-expand.min.js,importbuddy/js/jquery.simple-expand.min.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/jquery.simple-expand.min.js,importbuddy/js/jquery.simple-expand.min.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/main.js,importbuddy/js/main.js
alF1ZXJ5LmZuLnZpc2libGUgPSBmdW5jdGlvbigpIHsKCXJldHVybiB0aGlzLmNzcygndmlzaWJpbGl0eScsICd2aXNpYmxlJyk7Cn07CgpqUXVlcnkuZm4uaW52aXNpYmxlID0gZnVuY3Rpb24oKSB7CglyZXR1cm4gdGhpcy5jc3MoJ3Zpc2liaWxpdHknLCAnaGlkZGVuJyk7Cn07CgpqUXVlcnkuZm4udmlzaWJpbGl0eVRvZ2dsZSA9IGZ1bmN0aW9uKCkgewoJcmV0dXJuIHRoaXMuY3NzKCd2aXNpYmlsaXR5JywgZnVuY3Rpb24oaSwgdmlzaWJpbGl0eSkgewoJCXJldHVybiAodmlzaWJpbGl0eSA9PSAndmlzaWJsZScpID8gJ2hpZGRlbicgOiAndmlzaWJsZSc7Cgl9KTsKfTs=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/main.js,importbuddy/js/main.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/nprogress.js,importbuddy/js/nprogress.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/nprogress.js,importbuddy/js/nprogress.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/restoreEvents.js,importbuddy/js/restoreEvents.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/restoreEvents.js,importbuddy/js/restoreEvents.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/tooltip.js,importbuddy/js/tooltip.js
LyoKICogalF1ZXJ5IFRvb2x0aXAgcGx1Z2luIDEuMwogKgogKiBodHRwOi8vYmFzc2lzdGFuY2UuZGUvanF1ZXJ5LXBsdWdpbnMvanF1ZXJ5LXBsdWdpbi10b29sdGlwLwogKiBodHRwOi8vZG9jcy5qcXVlcnkuY29tL1BsdWdpbnMvVG9vbHRpcAogKgogKiBDb3B5cmlnaHQgKGMpIDIwMDYgLSAyMDA4IErDtnJuIFphZWZmZXJlcgogKgogKiAkSWQ6IGpxdWVyeS50b29sdGlwLmpzIDU3NDEgMjAwOC0wNi0yMSAxNToyMjoxNlogam9lcm4uemFlZmZlcmVyICQKICogCiAqIER1YWwgbGljZW5zZWQgdW5kZXIgdGhlIE1JVCBhbmQgR1BMIGxpY2Vuc2VzOgogKiAgIGh0dHA6Ly93d3cub3BlbnNvdXJjZS5vcmcvbGljZW5zZXMvbWl0LWxpY2Vuc2UucGhwCiAqICAgaHR0cDovL3d3dy5nbnUub3JnL2xpY2Vuc2VzL2dwbC5odG1sCiAqLwogCjsoZnVuY3Rpb24oJCkgewoJCgkJLy8gdGhlIHRvb2x0aXAgZWxlbWVudAoJdmFyIGhlbHBlciA9IHt9LAoJCS8vIHRoZSBjdXJyZW50IHRvb2x0aXBwZWQgZWxlbWVudAoJCWN1cnJlbnQsCgkJLy8gdGhlIHRpdGxlIG9mIHRoZSBjdXJyZW50IGVsZW1lbnQsIHVzZWQgZm9yIHJlc3RvcmluZwoJCXRpdGxlLAoJCS8vIHRpbWVvdXQgaWQgZm9yIGRlbGF5ZWQgdG9vbHRpcHMKCQl0SUQsCgkJLy8gSUUgNS41IG9yIDYKCQlJRSA9IGZhbHNlLAoJCS8vIGZsYWcgZm9yIG1vdXNlIHRyYWNraW5nCgkJdHJhY2sgPSBmYWxzZTsKCQoJJC50b29sdGlwID0gewoJCWJsb2NrZWQ6IGZhbHNlLAoJCWRlZmF1bHRzOiB7CgkJCWRlbGF5OiAyMDAsCgkJCWZhZGU6IGZhbHNlLAoJCQlzaG93VVJMOiB0cnVlLAoJCQlleHRyYUNsYXNzOiAiIiwKCQkJdG9wOiAxNSwKCQkJbGVmdDogMTUsCgkJCWlkOiAidG9vbHRpcCIKCQl9LAoJCWJsb2NrOiBmdW5jdGlvbigpIHsKCQkJJC50b29sdGlwLmJsb2NrZWQgPSAhJC50b29sdGlwLmJsb2NrZWQ7CgkJfQoJfTsKCQoJJC5mbi5leHRlbmQoewoJCXRvb2x0aXA6IGZ1bmN0aW9uKHNldHRpbmdzKSB7CgkJCXNldHRpbmdzID0gJC5leHRlbmQoe30sICQudG9vbHRpcC5kZWZhdWx0cywgc2V0dGluZ3MpOwoJCQljcmVhdGVIZWxwZXIoc2V0dGluZ3MpOwoJCQlyZXR1cm4gdGhpcy5lYWNoKGZ1bmN0aW9uKCkgewoJCQkJCSQuZGF0YSh0aGlzLCAidG9vbHRpcCIsIHNldHRpbmdzKTsKCQkJCQl0aGlzLnRPcGFjaXR5ID0gaGVscGVyLnBhcmVudC5jc3MoIm9wYWNpdHkiKTsKCQkJCQkvLyBjb3B5IHRvb2x0aXAgaW50byBpdHMgb3duIGV4cGFuZG8gYW5kIHJlbW92ZSB0aGUgdGl0bGUKCQkJCQl0aGlzLnRvb2x0aXBUZXh0ID0gdGhpcy50aXRsZTsKCQkJCQkkKHRoaXMpLnJlbW92ZUF0dHIoInRpdGxlIik7CgkJCQkJLy8gYWxzbyByZW1vdmUgYWx0IGF0dHJpYnV0ZSB0byBwcmV2ZW50IGRlZmF1bHQgdG9vbHRpcCBpbiBJRQoJCQkJCXRoaXMuYWx0ID0gIiI7CgkJCQl9KQoJCQkJLm1vdXNlb3ZlcihzYXZlKQoJCQkJLm1vdXNlb3V0KGhpZGUpCgkJCQkuY2xpY2soaGlkZSk7CgkJfSwKCQlmaXhQTkc6IElFID8gZnVuY3Rpb24oKSB7CgkJCXJldHVybiB0aGlzLmVhY2goZnVuY3Rpb24gKCkgewoJCQkJdmFyIGltYWdlID0gJCh0aGlzKS5jc3MoJ2JhY2tncm91bmRJbWFnZScpOwoJCQkJaWYgKGltYWdlLm1hdGNoKC9edXJsXChbIiddPyguKlwucG5nKVsiJ10/XCkkL2kpKSB7CgkJCQkJaW1hZ2UgPSBSZWdFeHAuJDE7CgkJCQkJJCh0aGlzKS5jc3MoewoJCQkJCQknYmFja2dyb3VuZEltYWdlJzogJ25vbmUnLAoJCQkJCQknZmlsdGVyJzogInByb2dpZDpEWEltYWdlVHJhbnNmb3JtLk1pY3Jvc29mdC5BbHBoYUltYWdlTG9hZGVyKGVuYWJsZWQ9dHJ1ZSwgc2l6aW5nTWV0aG9kPWNyb3AsIHNyYz0nIiArIGltYWdlICsgIicpIgoJCQkJCX0pLmVhY2goZnVuY3Rpb24gKCkgewoJCQkJCQl2YXIgcG9zaXRpb24gPSAkKHRoaXMpLmNzcygncG9zaXRpb24nKTsKCQkJCQkJaWYgKHBvc2l0aW9uICE9ICdhYnNvbHV0ZScgJiYgcG9zaXRpb24gIT0gJ3JlbGF0aXZlJykKCQkJCQkJCSQodGhpcykuY3NzKCdwb3NpdGlvbicsICdyZWxhdGl2ZScpOwoJCQkJCX0pOwoJCQkJfQoJCQl9KTsKCQl9IDogZnVuY3Rpb24oKSB7IHJldHVybiB0aGlzOyB9LAoJCXVuZml4UE5HOiBJRSA/IGZ1bmN0aW9uKCkgewoJCQlyZXR1cm4gdGhpcy5lYWNoKGZ1bmN0aW9uICgpIHsKCQkJCSQodGhpcykuY3NzKHsnZmlsdGVyJzogJycsIGJhY2tncm91bmRJbWFnZTogJyd9KTsKCQkJfSk7CgkJfSA6IGZ1bmN0aW9uKCkgeyByZXR1cm4gdGhpczsgfSwKCQloaWRlV2hlbkVtcHR5OiBmdW5jdGlvbigpIHsKCQkJcmV0dXJuIHRoaXMuZWFjaChmdW5jdGlvbigpIHsKCQkJCSQodGhpcylbICQodGhpcykuaHRtbCgpID8gInNob3ciIDogImhpZGUiIF0oKTsKCQkJfSk7CgkJfSwKCQl1cmw6IGZ1bmN0aW9uKCkgewoJCQlyZXR1cm4gdGhpcy5hdHRyKCdocmVmJykgfHwgdGhpcy5hdHRyKCdzcmMnKTsKCQl9Cgl9KTsKCQoJZnVuY3Rpb24gY3JlYXRlSGVscGVyKHNldHRpbmdzKSB7CgkJLy8gdGhlcmUgY2FuIGJlIG9ubHkgb25lIHRvb2x0aXAgaGVscGVyCgkJaWYoIGhlbHBlci5wYXJlbnQgKQoJCQlyZXR1cm47CgkJLy8gY3JlYXRlIHRoZSBoZWxwZXIsIGgzIGZvciB0aXRsZSwgZGl2IGZvciB1cmwKCQloZWxwZXIucGFyZW50ID0gJCgnPGRpdiBpZD0iJyArIHNldHRpbmdzLmlkICsgJyI+PGgzPjwvaDM+PGRpdiBjbGFzcz0iYm9keSI+PC9kaXY+PGRpdiBjbGFzcz0idXJsIj48L2Rpdj48L2Rpdj4nKQoJCQkvLyBhZGQgdG8gZG9jdW1lbnQKCQkJLmFwcGVuZFRvKGRvY3VtZW50LmJvZHkpCgkJCS8vIGhpZGUgaXQgYXQgZmlyc3QKCQkJLmhpZGUoKTsKCQkJCgkJLy8gYXBwbHkgYmdpZnJhbWUgaWYgYXZhaWxhYmxlCgkJaWYgKCAkLmZuLmJnaWZyYW1lICkKCQkJaGVscGVyLnBhcmVudC5iZ2lmcmFtZSgpOwoJCQoJCS8vIHNhdmUgcmVmZXJlbmNlcyB0byB0aXRsZSBhbmQgdXJsIGVsZW1lbnRzCgkJaGVscGVyLnRpdGxlID0gJCgnaDMnLCBoZWxwZXIucGFyZW50KTsKCQloZWxwZXIuYm9keSA9ICQoJ2Rpdi5ib2R5JywgaGVscGVyLnBhcmVudCk7CgkJaGVscGVyLnVybCA9ICQoJ2Rpdi51cmwnLCBoZWxwZXIucGFyZW50KTsKCX0KCQoJZnVuY3Rpb24gc2V0dGluZ3MoZWxlbWVudCkgewoJCXJldHVybiAkLmRhdGEoZWxlbWVudCwgInRvb2x0aXAiKTsKCX0KCQoJLy8gbWFpbiBldmVudCBoYW5kbGVyIHRvIHN0YXJ0IHNob3dpbmcgdG9vbHRpcHMKCWZ1bmN0aW9uIGhhbmRsZShldmVudCkgewoJCS8vIHNob3cgaGVscGVyLCBlaXRoZXIgd2l0aCB0aW1lb3V0IG9yIG9uIGluc3RhbnQKCQlpZiggc2V0dGluZ3ModGhpcykuZGVsYXkgKQoJCQl0SUQgPSBzZXRUaW1lb3V0KHNob3csIHNldHRpbmdzKHRoaXMpLmRlbGF5KTsKCQllbHNlCgkJCXNob3coKTsKCQkKCQkvLyBpZiBzZWxlY3RlZCwgdXBkYXRlIHRoZSBoZWxwZXIgcG9zaXRpb24gd2hlbiB0aGUgbW91c2UgbW92ZXMKCQl0cmFjayA9ICEhc2V0dGluZ3ModGhpcykudHJhY2s7CgkJJChkb2N1bWVudC5ib2R5KS5iaW5kKCdtb3VzZW1vdmUnLCB1cGRhdGUpOwoJCQkKCQkvLyB1cGRhdGUgYXQgbGVhc3Qgb25jZQoJCXVwZGF0ZShldmVudCk7Cgl9CgkKCS8vIHNhdmUgZWxlbWVudHMgdGl0bGUgYmVmb3JlIHRoZSB0b29sdGlwIGlzIGRpc3BsYXllZAoJZnVuY3Rpb24gc2F2ZSgpIHsKCQkvLyBpZiB0aGlzIGlzIHRoZSBjdXJyZW50IHNvdXJjZSwgb3IgaXQgaGFzIG5vIHRpdGxlIChvY2N1cnMgd2l0aCBjbGljayBldmVudCksIHN0b3AKCQlpZiAoICQudG9vbHRpcC5ibG9ja2VkIHx8IHRoaXMgPT0gY3VycmVudCB8fCAoIXRoaXMudG9vbHRpcFRleHQgJiYgIXNldHRpbmdzKHRoaXMpLmJvZHlIYW5kbGVyKSApCgkJCXJldHVybjsKCgkJLy8gc2F2ZSBjdXJyZW50CgkJY3VycmVudCA9IHRoaXM7CgkJdGl0bGUgPSB0aGlzLnRvb2x0aXBUZXh0OwoJCQoJCWlmICggc2V0dGluZ3ModGhpcykuYm9keUhhbmRsZXIgKSB7CgkJCWhlbHBlci50aXRsZS5oaWRlKCk7CgkJCXZhciBib2R5Q29udGVudCA9IHNldHRpbmdzKHRoaXMpLmJvZHlIYW5kbGVyLmNhbGwodGhpcyk7CgkJCWlmIChib2R5Q29udGVudC5ub2RlVHlwZSB8fCBib2R5Q29udGVudC5qcXVlcnkpIHsKCQkJCWhlbHBlci5ib2R5LmVtcHR5KCkuYXBwZW5kKGJvZHlDb250ZW50KQoJCQl9IGVsc2UgewoJCQkJaGVscGVyLmJvZHkuaHRtbCggYm9keUNvbnRlbnQgKTsKCQkJfQoJCQloZWxwZXIuYm9keS5zaG93KCk7CgkJfSBlbHNlIGlmICggc2V0dGluZ3ModGhpcykuc2hvd0JvZHkgKSB7CgkJCXZhciBwYXJ0cyA9IHRpdGxlLnNwbGl0KHNldHRpbmdzKHRoaXMpLnNob3dCb2R5KTsKCQkJaGVscGVyLnRpdGxlLmh0bWwocGFydHMuc2hpZnQoKSkuc2hvdygpOwoJCQloZWxwZXIuYm9keS5lbXB0eSgpOwoJCQlmb3IodmFyIGkgPSAwLCBwYXJ0OyAocGFydCA9IHBhcnRzW2ldKTsgaSsrKSB7CgkJCQlpZihpID4gMCkKCQkJCQloZWxwZXIuYm9keS5hcHBlbmQoIjxici8+Iik7CgkJCQloZWxwZXIuYm9keS5hcHBlbmQocGFydCk7CgkJCX0KCQkJaGVscGVyLmJvZHkuaGlkZVdoZW5FbXB0eSgpOwoJCX0gZWxzZSB7CgkJCWhlbHBlci50aXRsZS5odG1sKHRpdGxlKS5zaG93KCk7CgkJCWhlbHBlci5ib2R5LmhpZGUoKTsKCQl9CgkJCgkJLy8gaWYgZWxlbWVudCBoYXMgaHJlZiBvciBzcmMsIGFkZCBhbmQgc2hvdyBpdCwgb3RoZXJ3aXNlIGhpZGUgaXQKCQlpZiggc2V0dGluZ3ModGhpcykuc2hvd1VSTCAmJiAkKHRoaXMpLnVybCgpICkKCQkJaGVscGVyLnVybC5odG1sKCAkKHRoaXMpLnVybCgpLnJlcGxhY2UoJ2h0dHA6Ly8nLCAnJykgKS5zaG93KCk7CgkJZWxzZSAKCQkJaGVscGVyLnVybC5oaWRlKCk7CgkJCgkJLy8gYWRkIGFuIG9wdGlvbmFsIGNsYXNzIGZvciB0aGlzIHRpcAoJCWhlbHBlci5wYXJlbnQuYWRkQ2xhc3Moc2V0dGluZ3ModGhpcykuZXh0cmFDbGFzcyk7CgoJCS8vIGZpeCBQTkcgYmFja2dyb3VuZCBmb3IgSUUKCQlpZiAoc2V0dGluZ3ModGhpcykuZml4UE5HICkKCQkJaGVscGVyLnBhcmVudC5maXhQTkcoKTsKCQkJCgkJaGFuZGxlLmFwcGx5KHRoaXMsIGFyZ3VtZW50cyk7Cgl9CgkKCS8vIGRlbGV0ZSB0aW1lb3V0IGFuZCBzaG93IGhlbHBlcgoJZnVuY3Rpb24gc2hvdygpIHsKCQl0SUQgPSBudWxsOwoJCWlmICgoIUlFIHx8ICEkLmZuLmJnaWZyYW1lKSAmJiBzZXR0aW5ncyhjdXJyZW50KS5mYWRlKSB7CgkJCWlmIChoZWxwZXIucGFyZW50LmlzKCI6YW5pbWF0ZWQiKSkKCQkJCWhlbHBlci5wYXJlbnQuc3RvcCgpLnNob3coKS5mYWRlVG8oc2V0dGluZ3MoY3VycmVudCkuZmFkZSwgY3VycmVudC50T3BhY2l0eSk7CgkJCWVsc2UKCQkJCWhlbHBlci5wYXJlbnQuaXMoJzp2aXNpYmxlJykgPyBoZWxwZXIucGFyZW50LmZhZGVUbyhzZXR0aW5ncyhjdXJyZW50KS5mYWRlLCBjdXJyZW50LnRPcGFjaXR5KSA6IGhlbHBlci5wYXJlbnQuZmFkZUluKHNldHRpbmdzKGN1cnJlbnQpLmZhZGUpOwoJCX0gZWxzZSB7CgkJCWhlbHBlci5wYXJlbnQuc2hvdygpOwoJCX0KCQl1cGRhdGUoKTsKCX0KCQoJLyoqCgkgKiBjYWxsYmFjayBmb3IgbW91c2Vtb3ZlCgkgKiB1cGRhdGVzIHRoZSBoZWxwZXIgcG9zaXRpb24KCSAqIHJlbW92ZXMgaXRzZWxmIHdoZW4gbm8gY3VycmVudCBlbGVtZW50CgkgKi8KCWZ1bmN0aW9uIHVwZGF0ZShldmVudCkJewoJCWlmKCQudG9vbHRpcC5ibG9ja2VkKQoJCQlyZXR1cm47CgkJCgkJaWYgKGV2ZW50ICYmIGV2ZW50LnRhcmdldC50YWdOYW1lID09ICJPUFRJT04iKSB7CgkJCXJldHVybjsKCQl9CgkJCgkJLy8gc3RvcCB1cGRhdGluZyB3aGVuIHRyYWNraW5nIGlzIGRpc2FibGVkIGFuZCB0aGUgdG9vbHRpcCBpcyB2aXNpYmxlCgkJaWYgKCAhdHJhY2sgJiYgaGVscGVyLnBhcmVudC5pcygiOnZpc2libGUiKSkgewoJCQkkKGRvY3VtZW50LmJvZHkpLnVuYmluZCgnbW91c2Vtb3ZlJywgdXBkYXRlKQoJCX0KCQkKCQkvLyBpZiBubyBjdXJyZW50IGVsZW1lbnQgaXMgYXZhaWxhYmxlLCByZW1vdmUgdGhpcyBsaXN0ZW5lcgoJCWlmKCBjdXJyZW50ID09IG51bGwgKSB7CgkJCSQoZG9jdW1lbnQuYm9keSkudW5iaW5kKCdtb3VzZW1vdmUnLCB1cGRhdGUpOwoJCQlyZXR1cm47CQoJCX0KCQkKCQkvLyByZW1vdmUgcG9zaXRpb24gaGVscGVyIGNsYXNzZXMKCQloZWxwZXIucGFyZW50LnJlbW92ZUNsYXNzKCJ2aWV3cG9ydC1yaWdodCIpLnJlbW92ZUNsYXNzKCJ2aWV3cG9ydC1ib3R0b20iKTsKCQkKCQl2YXIgbGVmdCA9IGhlbHBlci5wYXJlbnRbMF0ub2Zmc2V0TGVmdDsKCQl2YXIgdG9wID0gaGVscGVyLnBhcmVudFswXS5vZmZzZXRUb3A7CgkJaWYgKGV2ZW50KSB7CgkJCS8vIHBvc2l0aW9uIHRoZSBoZWxwZXIgMTUgcGl4ZWwgdG8gYm90dG9tIHJpZ2h0LCBzdGFydGluZyBmcm9tIG1vdXNlIHBvc2l0aW9uCgkJCWxlZnQgPSBldmVudC5wYWdlWCArIHNldHRpbmdzKGN1cnJlbnQpLmxlZnQ7CgkJCXRvcCA9IGV2ZW50LnBhZ2VZICsgc2V0dGluZ3MoY3VycmVudCkudG9wOwoJCQl2YXIgcmlnaHQ9J2F1dG8nOwoJCQlpZiAoc2V0dGluZ3MoY3VycmVudCkucG9zaXRpb25MZWZ0KSB7CgkJCQlyaWdodCA9ICQod2luZG93KS53aWR0aCgpIC0gbGVmdDsKCQkJCWxlZnQgPSAnYXV0byc7CgkJCX0KCQkJaGVscGVyLnBhcmVudC5jc3MoewoJCQkJbGVmdDogbGVmdCwKCQkJCXJpZ2h0OiByaWdodCwKCQkJCXRvcDogdG9wCgkJCX0pOwoJCX0KCQkKCQl2YXIgdiA9IHZpZXdwb3J0KCksCgkJCWggPSBoZWxwZXIucGFyZW50WzBdOwoJCS8vIGNoZWNrIGhvcml6b250YWwgcG9zaXRpb24KCQlpZiAodi54ICsgdi5jeCA8IGgub2Zmc2V0TGVmdCArIGgub2Zmc2V0V2lkdGgpIHsKCQkJbGVmdCAtPSBoLm9mZnNldFdpZHRoICsgMjAgKyBzZXR0aW5ncyhjdXJyZW50KS5sZWZ0OwoJCQloZWxwZXIucGFyZW50LmNzcyh7bGVmdDogbGVmdCArICdweCd9KS5hZGRDbGFzcygidmlld3BvcnQtcmlnaHQiKTsKCQl9CgkJLy8gY2hlY2sgdmVydGljYWwgcG9zaXRpb24KCQlpZiAodi55ICsgdi5jeSA8IGgub2Zmc2V0VG9wICsgaC5vZmZzZXRIZWlnaHQpIHsKCQkJdG9wIC09IGgub2Zmc2V0SGVpZ2h0ICsgMjAgKyBzZXR0aW5ncyhjdXJyZW50KS50b3A7CgkJCWhlbHBlci5wYXJlbnQuY3NzKHt0b3A6IHRvcCArICdweCd9KS5hZGRDbGFzcygidmlld3BvcnQtYm90dG9tIik7CgkJfQoJfQoJCglmdW5jdGlvbiB2aWV3cG9ydCgpIHsKCQlyZXR1cm4gewoJCQl4OiAkKHdpbmRvdykuc2Nyb2xsTGVmdCgpLAoJCQl5OiAkKHdpbmRvdykuc2Nyb2xsVG9wKCksCgkJCWN4OiAkKHdpbmRvdykud2lkdGgoKSwKCQkJY3k6ICQod2luZG93KS5oZWlnaHQoKQoJCX07Cgl9CgkKCS8vIGhpZGUgaGVscGVyIGFuZCByZXN0b3JlIGFkZGVkIGNsYXNzZXMgYW5kIHRoZSB0aXRsZQoJZnVuY3Rpb24gaGlkZShldmVudCkgewoJCWlmKCQudG9vbHRpcC5ibG9ja2VkKQoJCQlyZXR1cm47CgkJLy8gY2xlYXIgdGltZW91dCBpZiBwb3NzaWJsZQoJCWlmKHRJRCkKCQkJY2xlYXJUaW1lb3V0KHRJRCk7CgkJLy8gbm8gbW9yZSBjdXJyZW50IGVsZW1lbnQKCQljdXJyZW50ID0gbnVsbDsKCQkKCQl2YXIgdHNldHRpbmdzID0gc2V0dGluZ3ModGhpcyk7CgkJZnVuY3Rpb24gY29tcGxldGUoKSB7CgkJCWhlbHBlci5wYXJlbnQucmVtb3ZlQ2xhc3MoIHRzZXR0aW5ncy5leHRyYUNsYXNzICkuaGlkZSgpLmNzcygib3BhY2l0eSIsICIiKTsKCQl9CgkJaWYgKCghSUUgfHwgISQuZm4uYmdpZnJhbWUpICYmIHRzZXR0aW5ncy5mYWRlKSB7CgkJCWlmIChoZWxwZXIucGFyZW50LmlzKCc6YW5pbWF0ZWQnKSkKCQkJCWhlbHBlci5wYXJlbnQuc3RvcCgpLmZhZGVUbyh0c2V0dGluZ3MuZmFkZSwgMCwgY29tcGxldGUpOwoJCQllbHNlCgkJCQloZWxwZXIucGFyZW50LnN0b3AoKS5mYWRlT3V0KHRzZXR0aW5ncy5mYWRlLCBjb21wbGV0ZSk7CgkJfSBlbHNlCgkJCWNvbXBsZXRlKCk7CgkJCgkJaWYoIHNldHRpbmdzKHRoaXMpLmZpeFBORyApCgkJCWhlbHBlci5wYXJlbnQudW5maXhQTkcoKTsKCX0KCQp9KShqUXVlcnkpOwo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/tooltip.js,importbuddy/js/tooltip.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/ui.core.js,importbuddy/js/ui.core.js
LyohCiAqIGpRdWVyeSBVSSAxLjguMTIKICoKICogQ29weXJpZ2h0IDIwMTEsIEFVVEhPUlMudHh0IChodHRwOi8vanF1ZXJ5dWkuY29tL2Fib3V0KQogKiBEdWFsIGxpY2Vuc2VkIHVuZGVyIHRoZSBNSVQgb3IgR1BMIFZlcnNpb24gMiBsaWNlbnNlcy4KICogaHR0cDovL2pxdWVyeS5vcmcvbGljZW5zZQogKgogKiBodHRwOi8vZG9jcy5qcXVlcnkuY29tL1VJCiAqLwooZnVuY3Rpb24oYyxqKXtmdW5jdGlvbiBrKGEpe3JldHVybiFjKGEpLnBhcmVudHMoKS5hbmRTZWxmKCkuZmlsdGVyKGZ1bmN0aW9uKCl7cmV0dXJuIGMuY3VyQ1NTKHRoaXMsInZpc2liaWxpdHkiKT09PSJoaWRkZW4ifHxjLmV4cHIuZmlsdGVycy5oaWRkZW4odGhpcyl9KS5sZW5ndGh9Yy51aT1jLnVpfHx7fTtpZighYy51aS52ZXJzaW9uKXtjLmV4dGVuZChjLnVpLHt2ZXJzaW9uOiIxLjguMTIiLGtleUNvZGU6e0FMVDoxOCxCQUNLU1BBQ0U6OCxDQVBTX0xPQ0s6MjAsQ09NTUE6MTg4LENPTU1BTkQ6OTEsQ09NTUFORF9MRUZUOjkxLENPTU1BTkRfUklHSFQ6OTMsQ09OVFJPTDoxNyxERUxFVEU6NDYsRE9XTjo0MCxFTkQ6MzUsRU5URVI6MTMsRVNDQVBFOjI3LEhPTUU6MzYsSU5TRVJUOjQ1LExFRlQ6MzcsTUVOVTo5MyxOVU1QQURfQUREOjEwNyxOVU1QQURfREVDSU1BTDoxMTAsTlVNUEFEX0RJVklERToxMTEsTlVNUEFEX0VOVEVSOjEwOCxOVU1QQURfTVVMVElQTFk6MTA2LApOVU1QQURfU1VCVFJBQ1Q6MTA5LFBBR0VfRE9XTjozNCxQQUdFX1VQOjMzLFBFUklPRDoxOTAsUklHSFQ6MzksU0hJRlQ6MTYsU1BBQ0U6MzIsVEFCOjksVVA6MzgsV0lORE9XUzo5MX19KTtjLmZuLmV4dGVuZCh7X2ZvY3VzOmMuZm4uZm9jdXMsZm9jdXM6ZnVuY3Rpb24oYSxiKXtyZXR1cm4gdHlwZW9mIGE9PT0ibnVtYmVyIj90aGlzLmVhY2goZnVuY3Rpb24oKXt2YXIgZD10aGlzO3NldFRpbWVvdXQoZnVuY3Rpb24oKXtjKGQpLmZvY3VzKCk7YiYmYi5jYWxsKGQpfSxhKX0pOnRoaXMuX2ZvY3VzLmFwcGx5KHRoaXMsYXJndW1lbnRzKX0sc2Nyb2xsUGFyZW50OmZ1bmN0aW9uKCl7dmFyIGE7YT1jLmJyb3dzZXIubXNpZSYmLyhzdGF0aWN8cmVsYXRpdmUpLy50ZXN0KHRoaXMuY3NzKCJwb3NpdGlvbiIpKXx8L2Fic29sdXRlLy50ZXN0KHRoaXMuY3NzKCJwb3NpdGlvbiIpKT90aGlzLnBhcmVudHMoKS5maWx0ZXIoZnVuY3Rpb24oKXtyZXR1cm4vKHJlbGF0aXZlfGFic29sdXRlfGZpeGVkKS8udGVzdChjLmN1ckNTUyh0aGlzLAoicG9zaXRpb24iLDEpKSYmLyhhdXRvfHNjcm9sbCkvLnRlc3QoYy5jdXJDU1ModGhpcywib3ZlcmZsb3ciLDEpK2MuY3VyQ1NTKHRoaXMsIm92ZXJmbG93LXkiLDEpK2MuY3VyQ1NTKHRoaXMsIm92ZXJmbG93LXgiLDEpKX0pLmVxKDApOnRoaXMucGFyZW50cygpLmZpbHRlcihmdW5jdGlvbigpe3JldHVybi8oYXV0b3xzY3JvbGwpLy50ZXN0KGMuY3VyQ1NTKHRoaXMsIm92ZXJmbG93IiwxKStjLmN1ckNTUyh0aGlzLCJvdmVyZmxvdy15IiwxKStjLmN1ckNTUyh0aGlzLCJvdmVyZmxvdy14IiwxKSl9KS5lcSgwKTtyZXR1cm4vZml4ZWQvLnRlc3QodGhpcy5jc3MoInBvc2l0aW9uIikpfHwhYS5sZW5ndGg/Yyhkb2N1bWVudCk6YX0sekluZGV4OmZ1bmN0aW9uKGEpe2lmKGEhPT1qKXJldHVybiB0aGlzLmNzcygiekluZGV4IixhKTtpZih0aGlzLmxlbmd0aCl7YT1jKHRoaXNbMF0pO2Zvcih2YXIgYjthLmxlbmd0aCYmYVswXSE9PWRvY3VtZW50Oyl7Yj1hLmNzcygicG9zaXRpb24iKTsKaWYoYj09PSJhYnNvbHV0ZSJ8fGI9PT0icmVsYXRpdmUifHxiPT09ImZpeGVkIil7Yj1wYXJzZUludChhLmNzcygiekluZGV4IiksMTApO2lmKCFpc05hTihiKSYmYiE9PTApcmV0dXJuIGJ9YT1hLnBhcmVudCgpfX1yZXR1cm4gMH0sZGlzYWJsZVNlbGVjdGlvbjpmdW5jdGlvbigpe3JldHVybiB0aGlzLmJpbmQoKGMuc3VwcG9ydC5zZWxlY3RzdGFydD8ic2VsZWN0c3RhcnQiOiJtb3VzZWRvd24iKSsiLnVpLWRpc2FibGVTZWxlY3Rpb24iLGZ1bmN0aW9uKGEpe2EucHJldmVudERlZmF1bHQoKX0pfSxlbmFibGVTZWxlY3Rpb246ZnVuY3Rpb24oKXtyZXR1cm4gdGhpcy51bmJpbmQoIi51aS1kaXNhYmxlU2VsZWN0aW9uIil9fSk7Yy5lYWNoKFsiV2lkdGgiLCJIZWlnaHQiXSxmdW5jdGlvbihhLGIpe2Z1bmN0aW9uIGQoZixnLGwsbSl7Yy5lYWNoKGUsZnVuY3Rpb24oKXtnLT1wYXJzZUZsb2F0KGMuY3VyQ1NTKGYsInBhZGRpbmciK3RoaXMsdHJ1ZSkpfHwwO2lmKGwpZy09cGFyc2VGbG9hdChjLmN1ckNTUyhmLAoiYm9yZGVyIit0aGlzKyJXaWR0aCIsdHJ1ZSkpfHwwO2lmKG0pZy09cGFyc2VGbG9hdChjLmN1ckNTUyhmLCJtYXJnaW4iK3RoaXMsdHJ1ZSkpfHwwfSk7cmV0dXJuIGd9dmFyIGU9Yj09PSJXaWR0aCI/WyJMZWZ0IiwiUmlnaHQiXTpbIlRvcCIsIkJvdHRvbSJdLGg9Yi50b0xvd2VyQ2FzZSgpLGk9e2lubmVyV2lkdGg6Yy5mbi5pbm5lcldpZHRoLGlubmVySGVpZ2h0OmMuZm4uaW5uZXJIZWlnaHQsb3V0ZXJXaWR0aDpjLmZuLm91dGVyV2lkdGgsb3V0ZXJIZWlnaHQ6Yy5mbi5vdXRlckhlaWdodH07Yy5mblsiaW5uZXIiK2JdPWZ1bmN0aW9uKGYpe2lmKGY9PT1qKXJldHVybiBpWyJpbm5lciIrYl0uY2FsbCh0aGlzKTtyZXR1cm4gdGhpcy5lYWNoKGZ1bmN0aW9uKCl7Yyh0aGlzKS5jc3MoaCxkKHRoaXMsZikrInB4Iil9KX07Yy5mblsib3V0ZXIiK2JdPWZ1bmN0aW9uKGYsZyl7aWYodHlwZW9mIGYhPT0ibnVtYmVyIilyZXR1cm4gaVsib3V0ZXIiK2JdLmNhbGwodGhpcyxmKTtyZXR1cm4gdGhpcy5lYWNoKGZ1bmN0aW9uKCl7Yyh0aGlzKS5jc3MoaCwKZCh0aGlzLGYsdHJ1ZSxnKSsicHgiKX0pfX0pO2MuZXh0ZW5kKGMuZXhwclsiOiJdLHtkYXRhOmZ1bmN0aW9uKGEsYixkKXtyZXR1cm4hIWMuZGF0YShhLGRbM10pfSxmb2N1c2FibGU6ZnVuY3Rpb24oYSl7dmFyIGI9YS5ub2RlTmFtZS50b0xvd2VyQ2FzZSgpLGQ9Yy5hdHRyKGEsInRhYmluZGV4Iik7aWYoImFyZWEiPT09Yil7Yj1hLnBhcmVudE5vZGU7ZD1iLm5hbWU7aWYoIWEuaHJlZnx8IWR8fGIubm9kZU5hbWUudG9Mb3dlckNhc2UoKSE9PSJtYXAiKXJldHVybiBmYWxzZTthPWMoImltZ1t1c2VtYXA9IyIrZCsiXSIpWzBdO3JldHVybiEhYSYmayhhKX1yZXR1cm4oL2lucHV0fHNlbGVjdHx0ZXh0YXJlYXxidXR0b258b2JqZWN0Ly50ZXN0KGIpPyFhLmRpc2FibGVkOiJhIj09Yj9hLmhyZWZ8fCFpc05hTihkKTohaXNOYU4oZCkpJiZrKGEpfSx0YWJiYWJsZTpmdW5jdGlvbihhKXt2YXIgYj1jLmF0dHIoYSwidGFiaW5kZXgiKTtyZXR1cm4oaXNOYU4oYil8fGI+PTApJiZjKGEpLmlzKCI6Zm9jdXNhYmxlIil9fSk7CmMoZnVuY3Rpb24oKXt2YXIgYT1kb2N1bWVudC5ib2R5LGI9YS5hcHBlbmRDaGlsZChiPWRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoImRpdiIpKTtjLmV4dGVuZChiLnN0eWxlLHttaW5IZWlnaHQ6IjEwMHB4IixoZWlnaHQ6ImF1dG8iLHBhZGRpbmc6MCxib3JkZXJXaWR0aDowfSk7Yy5zdXBwb3J0Lm1pbkhlaWdodD1iLm9mZnNldEhlaWdodD09PTEwMDtjLnN1cHBvcnQuc2VsZWN0c3RhcnQ9Im9uc2VsZWN0c3RhcnQiaW4gYjthLnJlbW92ZUNoaWxkKGIpLnN0eWxlLmRpc3BsYXk9Im5vbmUifSk7Yy5leHRlbmQoYy51aSx7cGx1Z2luOnthZGQ6ZnVuY3Rpb24oYSxiLGQpe2E9Yy51aVthXS5wcm90b3R5cGU7Zm9yKHZhciBlIGluIGQpe2EucGx1Z2luc1tlXT1hLnBsdWdpbnNbZV18fFtdO2EucGx1Z2luc1tlXS5wdXNoKFtiLGRbZV1dKX19LGNhbGw6ZnVuY3Rpb24oYSxiLGQpe2lmKChiPWEucGx1Z2luc1tiXSkmJmEuZWxlbWVudFswXS5wYXJlbnROb2RlKWZvcih2YXIgZT0wO2U8Yi5sZW5ndGg7ZSsrKWEub3B0aW9uc1tiW2VdWzBdXSYmCmJbZV1bMV0uYXBwbHkoYS5lbGVtZW50LGQpfX0sY29udGFpbnM6ZnVuY3Rpb24oYSxiKXtyZXR1cm4gZG9jdW1lbnQuY29tcGFyZURvY3VtZW50UG9zaXRpb24/YS5jb21wYXJlRG9jdW1lbnRQb3NpdGlvbihiKSYxNjphIT09YiYmYS5jb250YWlucyhiKX0saGFzU2Nyb2xsOmZ1bmN0aW9uKGEsYil7aWYoYyhhKS5jc3MoIm92ZXJmbG93Iik9PT0iaGlkZGVuIilyZXR1cm4gZmFsc2U7Yj1iJiZiPT09ImxlZnQiPyJzY3JvbGxMZWZ0Ijoic2Nyb2xsVG9wIjt2YXIgZD1mYWxzZTtpZihhW2JdPjApcmV0dXJuIHRydWU7YVtiXT0xO2Q9YVtiXT4wO2FbYl09MDtyZXR1cm4gZH0saXNPdmVyQXhpczpmdW5jdGlvbihhLGIsZCl7cmV0dXJuIGE+YiYmYTxiK2R9LGlzT3ZlcjpmdW5jdGlvbihhLGIsZCxlLGgsaSl7cmV0dXJuIGMudWkuaXNPdmVyQXhpcyhhLGQsaCkmJmMudWkuaXNPdmVyQXhpcyhiLGUsaSl9fSl9fSkoalF1ZXJ5KTs=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/ui.core.js,importbuddy/js/ui.core.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/ui.tabs.js,importbuddy/js/ui.tabs.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/ui.tabs.js,importbuddy/js/ui.tabs.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/ui.widget.js,importbuddy/js/ui.widget.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/ui.widget.js,importbuddy/js/ui.widget.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/lib/index.php,importbuddy/lib/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/lib/index.php,importbuddy/lib/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_assets.php,importbuddy/views/_assets.php
PD9waHAKcGJfYmFja3VwYnVkZHk6OmxvYWRfc3R5bGUoICdzdHlsZS5jc3MnICk7CgpwYl9iYWNrdXBidWRkeTo6bG9hZF9zY3JpcHQoICdqcXVlcnkuanMnICk7CnBiX2JhY2t1cGJ1ZGR5Ojpsb2FkX3NjcmlwdCggJ3VpLmNvcmUuanMnICk7CnBiX2JhY2t1cGJ1ZGR5Ojpsb2FkX3NjcmlwdCggJ3VpLndpZGdldC5qcycgKTsKcGJfYmFja3VwYnVkZHk6OmxvYWRfc2NyaXB0KCAndWkudGFicy5qcycgKTsKcGJfYmFja3VwYnVkZHk6OmxvYWRfc2NyaXB0KCAndG9vbHRpcC5qcycgKTsKcGJfYmFja3VwYnVkZHk6OmxvYWRfc2NyaXB0KCAnbnByb2dyZXNzLmpzJyApOwpwYl9iYWNrdXBidWRkeTo6bG9hZF9zY3JpcHQoICdpbXBvcnRidWRkeS5qcycgKTsKCi8vIFR1dG9yaWFsCnBiX2JhY2t1cGJ1ZGR5Ojpsb2FkX3NjcmlwdCggJ2pxdWVyeS5qb3lyaWRlLTIuMC4zLmpzJyApOwpwYl9iYWNrdXBidWRkeTo6bG9hZF9zY3JpcHQoICdtb2Rlcm5penIubXEuanMnICk7CnBiX2JhY2t1cGJ1ZGR5Ojpsb2FkX3N0eWxlKCAnam95cmlkZS5jc3MnICk7CnBiX2JhY2t1cGJ1ZGR5Ojpsb2FkX3N0eWxlKCAnbnByb2dyZXNzLmNzcycgKTs=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_assets.php,importbuddy/views/_assets.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_dbreplace.php,importbuddy/views/_dbreplace.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_dbreplace.php,importbuddy/views/_dbreplace.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_footer.php,importbuddy/views/_footer.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9Cj8+Cgo8L2Rpdj4KPC9kaXY+CgoKPC9ib2R5Pgo8L2h0bWw+Cg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_footer.php,importbuddy/views/_footer.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_header.php,importbuddy/views/_header.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_header.php,importbuddy/views/_header.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_html_1_stash.php,importbuddy/views/_html_1_stash.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_html_1_stash.php,importbuddy/views/_html_1_stash.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_iframe_footer.php,importbuddy/views/_iframe_footer.php
CTxzY3JpcHQ+Ly9iYl9hY3Rpb24oICdpZnJhbWVMb2FkZWQnICk7PC9zY3JpcHQ+CjwvaHRtbD4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_iframe_footer.php,importbuddy/views/_iframe_footer.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_iframe_header.php,importbuddy/views/_iframe_header.php
PGh0bWw+Cjw/cGhwCnJlcXVpcmUoICdfYXNzZXRzLnBocCcgKTsKCgoKaWYgKCAndHJ1ZScgIT0gcGJfYmFja3VwYnVkZHk6Ol9HRVQoICdkZXBsb3knICkgKSB7IC8vIE5PUk1BTCwgTk9UIERFUExPWU1FTlQuCj8+Cgk8c2NyaXB0PgoJCXZhciB3aW4gPSB3aW5kb3cuZGlhbG9nQXJndW1lbnRzIHx8IG9wZW5lciB8fCBwYXJlbnQgfHwgdG9wOwoJCXdpbi53aW5kb3cuc2Nyb2xsVG8oMCwwKTsKCQkKCQlmdW5jdGlvbiBwYl9zdGF0dXNfYXBwZW5kKCBzdGF0dXNfc3RyaW5nICkgewoJCQkvL3ZhciB3aW4gPSB3aW5kb3cuZGlhbG9nQXJndW1lbnRzIHx8IG9wZW5lciB8fCBwYXJlbnQgfHwgdG9wOwoJCQl3aW4ucGJfc3RhdHVzX2FwcGVuZCggc3RhdHVzX3N0cmluZyApOwoJCX0KCQlmdW5jdGlvbiBwYl9zdGF0dXNfdW5kb3VybCggdW5kb191cmwgKSB7CgkJCS8vdmFyIHdpbiA9IHdpbmRvdy5kaWFsb2dBcmd1bWVudHMgfHwgb3BlbmVyIHx8IHBhcmVudCB8fCB0b3A7CgkJCXdpbi5wYl9zdGF0dXNfdW5kb3VybCggdW5kb191cmwgKTsKCQl9CgkJCgkJCgkJCgkJZnVuY3Rpb24gcGFnZVRpdGxlKCB0aXRsZSApIHsKCQkJCgkJCXdpbi5qUXVlcnkoICcjcGFnZVRpdGxlJyApLmh0bWwoIHRpdGxlICk7CgkJfQoJCQoJCWZ1bmN0aW9uIGJiX2FjdGlvbiggYWN0aW9uLCBub3RlICkgewoJCQl3aW4uYmJfYWN0aW9uKCBhY3Rpb24sIG5vdGUgKTsKCQl9CgkJCgkJZnVuY3Rpb24gYmJfcmVzdG9yZURhdGEoIGRhdGEgKSB7CgkJCXdpbi5iYl9yZXN0b3JlRGF0YSggZGF0YSApOwoJCX0KCQkKCQlmdW5jdGlvbiBiYl9zaG93U3RlcCggc3RlcCwgZGF0YSApIHsKCQkJd2luLmJiX3Nob3dTdGVwKCBzdGVwLCBkYXRhICk7CgkJfQoJCQoJPC9zY3JpcHQ+Cjw/cGhwIH0gZWxzZSB7IC8vIERFUExPWU1FTlQgPz4KCTxzY3JpcHQ+CgkJZnVuY3Rpb24gcGJfc3RhdHVzX2FwcGVuZCgpIHsKCQl9CgkJCgkJZnVuY3Rpb24gcGJfc3RhdHVzX3VuZG91cmwoIHVuZG9fdXJsICkgewoJCX0KCQkKCQlmdW5jdGlvbiBwYWdlVGl0bGUoIHRpdGxlICkgewoJCX0KCQkKCQlmdW5jdGlvbiBiYl9hY3Rpb24oIGFjdGlvbiwgbm90ZSApIHsKCQl9CgkJCgkJZnVuY3Rpb24gYmJfcmVzdG9yZURhdGEoIGRhdGEgKSB7CgkJfQoJCQoJCWZ1bmN0aW9uIGJiX3Nob3dTdGVwKCBzdGVwLCBkYXRhICkgewoJCX0KCTwvc2NyaXB0Pgo8P3BocCB9ID8+
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_iframe_header.php,importbuddy/views/_iframe_header.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/cleanupSettings.htm,importbuddy/views/cleanupSettings.htm
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/cleanupSettings.htm,importbuddy/views/cleanupSettings.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/cpanelTutorial.htm,importbuddy/views/cpanelTutorial.htm
PG9iamVjdCBjbGFzc2lkPSJjbHNpZDpkMjdjZGI2ZS1hZTZkLTExY2YtOTZiOC00NDQ1NTM1NDAwMDAiIGNvZGViYXNlPSJodHRwOi8vZnBkb3dubG9hZC5tYWNyb21lZGlhLmNvbS9wdWIvc2hvY2t3YXZlL2NhYnMvZmxhc2gvc3dmbGFzaC5jYWIjdmVyc2lvbj03LDAsMCwwIiBpZD0iQ2FwdGl2YXRlMSI+Cgk8cGFyYW0gbmFtZT0ibW92aWUiIHZhbHVlPSJodHRwOi8vd3d3LmNwYW5lbC5uZXQvbWVkaWEvdHV0b3JpYWxzL215c3Fsd2l6YXJkLnN3ZiI+Cgk8cGFyYW0gbmFtZT0icXVhbGl0eSIgdmFsdWU9ImhpZ2giPjxwYXJhbSBuYW1lPSJsb29wIiB2YWx1ZT0iMCI+Cgk8ZW1iZWQgc3JjPSJodHRwOi8vd3d3LmNwYW5lbC5uZXQvbWVkaWEvdHV0b3JpYWxzL215c3Fsd2l6YXJkLnN3ZiIgd2lkdGg9IjEwMCUiIGhlaWdodD0iNTAwIiBsb29wPSIwIiBxdWFsaXR5PSJsb3ciIHBsdWdpbnNwYWdlPSJodHRwOi8vd3d3Lm1hY3JvbWVkaWEuY29tL2dvL2dldGZsYXNocGxheWVyIiB0eXBlPSJhcHBsaWNhdGlvbi94LXNob2Nrd2F2ZS1mbGFzaCIgbWVudT0iZmFsc2UiPgo8L29iamVjdD4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/cpanelTutorial.htm,importbuddy/views/cpanelTutorial.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/databaseSettings.htm,importbuddy/views/databaseSettings.htm
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/databaseSettings.htm,importbuddy/views/databaseSettings.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/dbreplace.php,importbuddy/views/dbreplace.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/dbreplace.php,importbuddy/views/dbreplace.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/finalCleanup.htm,importbuddy/views/finalCleanup.htm
VGhpcyBzdGVwIGhhbmRsZXMgZGVsZXRpbmcgZmlsZXMuIEluIHJhcmUgaW5zdGFuY2VzIG9uIHNvbWUgc2VydmVycyB5b3UgbWF5IHJlY2VpdmUgZXJyb3JzIGxvYWRpbmcgZmlsZXMgb3IgYW4gdW5zdHlsZWQgcGFnZSBoZXJlIGR1ZSB0byBmaWxlcyBnZXR0aW5nIGRlbGV0aW5nIHByZW1hdHVyZWx5IGJlZm9yZSB0aGUgcGFnZSBjb21wbGV0ZXMgbG9hZGluZy4gVGhpcyBtYXkgc2FmZWx5IGJlIGlnbm9yZWQuIEl0IGlzIGNvbW1vbiB0byBub3QgYmUgYWJsZSB0byBkZWxldGUgc29tZSBmaWxlcyBkdWUgdG8gcGVybWlzc2lvbiBlcnJvcnMuIFlvdSBtYXkgbWFudWFsbHkgZGVsZXRlIHRoZW0uIDxiPmltcG9ydGJ1ZGR5LnBocDwvYj4gc2hvdWxkIGFsd2F5cyBiZSBkZWxldGVkIGFmdGVyIHJlc3RvcmUgZm9yIGJlc3Qgc2VjdXJpdHkuCgo8aDMgc3R5bGU9InRleHQtYWxpZ246IGNlbnRlcjsiPllvdXIgc2l0ZSBpcyByZWFkeSB0byBnbyBhdAo8YSBocmVmPSI8JT1ob21ldXJsJT4iIHRhcmdldD0iX2JsYW5rIj48Yj48JT1ob21ldXJsJT48L2I+PC9hPjxicj48YnI+ClRoYW5rIHlvdSBmb3IgY2hvb3NpbmcgQmFja3VwQnVkZHkhPC9oMz4KCgo8L2Rpdj48L2Rpdj48YnI+PGJyPjxicj4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/finalCleanup.htm,importbuddy/views/finalCleanup.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/finished.htm,importbuddy/views/finished.htm
PGgxPlJlc3RvcmUgRmluaXNoZWQuPC9oMT4KCjxoMz5Zb3VyIHNpdGUgc2hvdWxkIGJlIHJlYWR5IHRvIGdvIGF0Ojxicj48YnI+PGEgaHJlZj0iPCU9aG9tZXVybCU+IiB0YXJnZXQ9Il9ibGFuayI+PCU9aG9tZXVybCU+PC9hPjwvaDM+PGJyPg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/finished.htm,importbuddy/views/finished.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/home.php,importbuddy/views/home.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/home.php,importbuddy/views/home.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/importingDatabase.htm,importbuddy/views/importingDatabase.htm
PGNlbnRlcj4KCTxoMz5SZXN0b3JpbmcgRGF0YWJhc2UgLi4uPC9oMz4KCTxoNCBpZD0iaW1wb3J0aW5nRGF0YWJhc2UtcHJvZ3Jlc3NNZXNzYWdlIj48L2g0Pgo8L2NlbnRlcj4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/importingDatabase.htm,importbuddy/views/importingDatabase.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/index.php,importbuddy/views/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/index.php,importbuddy/views/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/login.php,importbuddy/views/login.php
PHNjcmlwdD5qUXVlcnkoICcjcGFnZVRpdGxlJyApLmh0bWwoICdBdXRoZW50aWNhdGlvbiBSZXF1aXJlZCcgKTs8L3NjcmlwdD4KPD9waHAKCgppZiAoIHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ3Bhc3N3b3JkJyApICE9ICcnICkgewoJZ2xvYmFsICRwYl9sb2dpbl9hdHRlbXB0czsKCXBiX2JhY2t1cGJ1ZGR5OjphbGVydCggJ0ludmFsaWQgcGFzc3dvcmQuIFBsZWFzZSBlbnRlciB0aGUgcGFzc3dvcmQgeW91IHByb3ZpZGVkIHdpdGhpbiBCYWNrdXBCdWRkeSBTZXR0aW5ncy4gQXR0ZW1wdCAjJyAuICRwYl9sb2dpbl9hdHRlbXB0cyAuICcuJyApOwoJZWNobyAnPGJyPic7Cn0KPz4KCjxwPkVudGVyIHlvdXIgSW1wb3J0QnVkZHkgcGFzc3dvcmQgYmVsb3cgdG8gYmVnaW4uPC9wPgoKPGZvcm0gbWV0aG9kPSJwb3N0Ij4KCTxpbnB1dCB0eXBlPSJoaWRkZW4iIG5hbWU9ImFjdGlvbiIgdmFsdWU9ImxvZ2luIj4KCTxpbnB1dCB0eXBlPSJwYXNzd29yZCIgbmFtZT0icGFzc3dvcmQiIHN0eWxlPSJ3aWR0aDogMjUwcHg7Ij4KCTxpbnB1dCB0eXBlPSJzdWJtaXQiIG5hbWU9InN1Ym1pdCIgdmFsdWU9IkF1dGhlbnRpY2F0ZSIgY2xhc3M9Iml0LWJ1dHRvbiI+CjwvZm9ybT4K
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/login.php,importbuddy/views/login.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/migratingDatabase.htm,importbuddy/views/migratingDatabase.htm
PGNlbnRlcj4KCTxoMz5NaWdyYXRpbmcgRGF0YWJhc2UgLi4uPC9oMz4KCTxoNCBpZD0ibWlncmF0aW5nRGF0YWJhc2UtcHJvZ3Jlc3NNZXNzYWdlIj48L2g0Pgo8L2NlbnRlcj4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/migratingDatabase.htm,importbuddy/views/migratingDatabase.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/unzippingFiles.htm,importbuddy/views/unzippingFiles.htm
PGNlbnRlcj4KCTxoMz5QbGVhc2Ugd2FpdCB3aGlsZSB5b3VyIGZpbGVzIGFyZSByZXN0b3JlZCAuLi48L2gzPgoJPGg0IGlkPSJ1bnppcHBpbmdGaWxlcy1wcm9ncmVzc01lc3NhZ2UiPlJlc3RvcmluZyBGaWxlczwvaDQ+CjwvY2VudGVyPg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/unzippingFiles.htm,importbuddy/views/unzippingFiles.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/urlReplaceSettings.htm,importbuddy/views/urlReplaceSettings.htm
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/urlReplaceSettings.htm,importbuddy/views/urlReplaceSettings.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/2.php,importbuddy/controllers/ajax/2.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/2.php,importbuddy/controllers/ajax/2.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/4.php,importbuddy/controllers/ajax/4.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/4.php,importbuddy/controllers/ajax/4.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/5.php,importbuddy/controllers/ajax/5.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/5.php,importbuddy/controllers/ajax/5.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/6.php,importbuddy/controllers/ajax/6.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/6.php,importbuddy/controllers/ajax/6.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/_stats.php,importbuddy/controllers/ajax/_stats.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/_stats.php,importbuddy/controllers/ajax/_stats.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/cpanel_createdb.php,importbuddy/controllers/ajax/cpanel_createdb.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgpBdXRoOjpyZXF1aXJlX2F1dGhlbnRpY2F0aW9uKCk7IC8vIERpZSBpZiBub3QgbG9nZ2VkIGluLgoKLy9wcmludF9yKCBwYl9iYWNrdXBidWRkeTo6X1BPU1QoKSApOwoKJGNwYW5lbF91c2VyID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX3VzZXInICk7CiRjcGFuZWxfcGFzc3dvcmQgPSBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdjcGFuZWxfcGFzcycgKTsKJGNwYW5lbF9ob3N0ID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX3VybCcgKTsKJGNwYW5lbF9wb3J0ID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX3BvcnQnICk7CiRkYl9uYW1lID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX2RibmFtZScgKTsKJGRiX3VzZXIgPSBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdjcGFuZWxfZGJ1c2VyJyApOwokZGJfcGFzcyA9IHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ2NwYW5lbF9kYnBhc3MnICk7CgovLyBOZWVkZWQgZm9yIEhUVFAgcmVxdWVzdHMuCiRyZXF1ZXN0Y29yZV9maWxlID0gcGJfYmFja3VwYnVkZHk6OnBsdWdpbl9wYXRoKCkgLiAnL2xpYi9yZXF1ZXN0Y29yZS9yZXF1ZXN0Y29yZS5jbGFzcy5waHAnOwpyZXF1aXJlX29uY2UoICRyZXF1ZXN0Y29yZV9maWxlICk7CgpyZXF1aXJlX29uY2UoIHBiX2JhY2t1cGJ1ZGR5OjpwbHVnaW5fcGF0aCgpIC4gJy9saWIvY3BhbmVsL2NwYW5lbC5waHAnICk7CiRjcmVhdGVfZGJfcmVzdWx0ID0gcGJfYmFja3VwYnVkZHlfY3BhbmVsOjpjcmVhdGVfZGIoICRjcGFuZWxfdXNlciwgJGNwYW5lbF9wYXNzd29yZCwgJGNwYW5lbF9ob3N0LCAkZGJfbmFtZSwgJGRiX3VzZXIsICRkYl9wYXNzLCAkY3BhbmVsX3BvcnQgKTsKCmlmICggJGNyZWF0ZV9kYl9yZXN1bHQgPT09IHRydWUgKSB7CgllY2hvICdTdWNjZXNzISBDcmVhdGVkIGRhdGFiYXNlLCB1c2VyLCBhbmQgYXNzaWduZWQgdXNlciB0byBkYXRhYmFzZS4nOwp9IGVsc2UgewoJZWNobyAiVW5hYmxlIHRvIGF1dG9tYXRpY2FsbHkgY3JlYXRlIGRhdGFiYXNlIHdpdGggdGhlIHByb3ZpZGVkIHNldHRpbmdzLiBDaGVjayBzZXR0aW5ncyBvciBtYW51YWxseSBjcmVhdGUgdGhlIGRhdGFiYXNlIGZyb20geW91ciBob3N0J3MgY29udHJvbCBwYW5lbC4gU2VlIHR1dG9yaWFsIGF0OiAiOwoJZWNobyAiaHR0cDovL2l0aGVtZXMuY29tL3R1dG9yaWFsLWNyZWF0ZS1kYXRhYmFzZS1pbi1jcGFuZWwvXG5cbiI7CgllY2hvICJFcnJvciBkZXRhaWxzOlxuIiAuIGltcGxvZGUoICJcbiIsICRjcmVhdGVfZGJfcmVzdWx0KTsKfQoKZGllKCk7Cg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/cpanel_createdb.php,importbuddy/controllers/ajax/cpanel_createdb.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/create_admin.php,importbuddy/controllers/ajax/create_admin.php
PD9waHAKZGllKCAnPGh0bWw+PC9odG1sPicgKTsgLy8gRElTQUJMRUQuCgpBdXRoOjpyZXF1aXJlX2F1dGhlbnRpY2F0aW9uKCk7IC8vIERpZSBpZiBub3QgbG9nZ2VkIGluLgoKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgppZiAoIGZpbGVfZXhpc3RzKCBBQlNQQVRIIC4gJ3dwLWxvYWQucGhwJyApICkgewoJb2Jfc3RhcnQoICdvYl9lcnJvcl9oYW5kbGVyJyApOyAvL1N1cHByZXNzIGVycm9ycwoJcmVxdWlyZV9vbmNlKCBBQlNQQVRIIC4gJ3dwLWxvYWQucGhwJyApOwoJb2JfZW5kX2NsZWFuKCk7Cn0gZWxzZSB7CglkaWUoICdVbmFibGUgdG8gZmluZCBXb3JkUHJlc3MgZmlsZXMgdG8gbG9hZCAod3AtbG9hZC5waHApLiBWZXJpZnkgeW91ciBXb3JkUHJlc3Mgc2l0ZSBpcyBmdW5jdGlvbmFsIGFuZCBhYmxlIHRvIGNvbm5lY3QgdG8gdGhlIGRhdGFiYXNlLicgKTsKfQoKJHVzZXIgPSBnZXRfdXNlcl9ieSggJ2xvZ2luJywgJHNlYXJjaF9zdHJpbmcgKTsKaWYgKCAkdXNlciApIGRpZSgganNvbl9lbmNvZGUoICR1c2VyICkgKTsK
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/create_admin.php,importbuddy/controllers/ajax/create_admin.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/file_hash.php,importbuddy/controllers/ajax/file_hash.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CkF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCgokZmlsZSA9IEFCU1BBVEggLiBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdmaWxlJyApOwoKaWYgKCAnJyA9PSAkZmlsZSApIHsKCWRpZSggJ05vIGZpbGUgcGFzc2VkLicgKTsKfQppZiAoICEgZmlsZV9leGlzdHMoICRmaWxlICkgKSB7CglkaWUoICdGaWxlIG5vdCBmb3VuZC4nICk7Cn0KCiRmaWxlSGFzaCA9IEBtZDVfZmlsZSggJGZpbGUgKTsKCmlmICggZmFsc2UgPT09ICRmaWxlSGFzaCApIHsKCWRpZSggJ1VuYWJsZSB0byBjYWxjdWxhdGUgaGFzaC4gVmVyaWZ5IGZpbGUgcGVybWlzc2lvbnMuJyApOwp9IGVsc2UgewoJZGllKCBqc29uX2VuY29kZSggYXJyYXkoICdoYXNoJyA9PiAkZmlsZUhhc2ggKSApICk7Cn0=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/file_hash.php,importbuddy/controllers/ajax/file_hash.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/getDeployLog.php,importbuddy/controllers/ajax/getDeployLog.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgppZiAoICd0cnVlJyAhPSBwYl9iYWNrdXBidWRkeTo6X0dFVCggJ2RlcGxveScgKSApIHsKCWRpZSggJ0FjY2VzcyBkZW5pZWQuJyApOwp9CgovLyBPbmx5IGFsbG93IGFjY2VzcyB0byB0aGlzIGZpbGUgaWYgaXQgaGFzIGEgc2VyaWFsIGhpZGluZyBpdC4gVXNlZCBieSBkZXBsb3ltZW50LgpnbG9iYWwgJGltcG9ydGJ1ZGR5X2ZpbGU7CiRpbXBvcnRGaWxlU2VyaWFsID0gYmFja3VwYnVkZHlfY29yZTo6Z2V0X3NlcmlhbF9mcm9tX2ZpbGUoICRpbXBvcnRidWRkeV9maWxlICk7CmlmICggJycgPT0gJGltcG9ydEZpbGVTZXJpYWwgKSB7CglkaWUoICdBY2Nlc3MgZGVuaWVkLicgKTsKfQoKcGJfYmFja3VwYnVkZHk6OnN0YXR1cyggJ2RldGFpbHMnLCAnKioqIEVuZCBJbXBvcnRCdWRkeSBMb2cgc2VjdGlvbicgKTsKJHN0YXR1c19saW5lcyA9IHBiX2JhY2t1cGJ1ZGR5OjpnZXRfc3RhdHVzKCAnJywgdHJ1ZSwgZmFsc2UsIHRydWUgKTsgLy8gQ2xlYXIgZmlsZSwgZG9udCB1bmxpbmsgZmlsZSwgc3VwcmVzcyBzdGF0dXMgcmV0cmlldmFsIG1zZy4KZWNobyBpbXBsb2RlKCAnJywgJHN0YXR1c19saW5lcyApOwoK
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/getDeployLog.php,importbuddy/controllers/ajax/getDeployLog.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/index.php,importbuddy/controllers/ajax/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/index.php,importbuddy/controllers/ajax/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/mysql_test.php,importbuddy/controllers/ajax/mysql_test.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CkF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCgovLyBJbmNsdWRlIHRoZSBEQiBUZXN0cyBjbGFzcyBhbmQgaW5pdCBpdC4KcmVxdWlyZV9vbmNlKCBBQlNQQVRIIC4gJ2ltcG9ydGJ1ZGR5L2NsYXNzZXMvdGVzdC1kYi5waHAnICk7CiRpbXBvcnRidWRkeV90ZXN0X2RiID0gbmV3IGltcG9ydGJ1ZGR5X3Rlc3RfZGIoKTsK
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/mysql_test.php,importbuddy/controllers/ajax/mysql_test.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/create_admin.php,importbuddy/controllers/pages/create_admin.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/create_admin.php,importbuddy/controllers/pages/create_admin.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/dbreplace.php,importbuddy/controllers/pages/dbreplace.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CkF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCgoKJGRhdGEgPSBhcnJheSgpOwpwYl9iYWNrdXBidWRkeTo6bG9hZF92aWV3KCAnZGJyZXBsYWNlJywgJGRhdGEgKTsKPz48c2NyaXB0PmpRdWVyeSggJyNwYWdlVGl0bGUnICkuaHRtbCggJ0RhdGFiYXNlIFRleHQgUmVwbGFjZScgKTs8L3NjcmlwdD4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/dbreplace.php,importbuddy/controllers/pages/dbreplace.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/default.php,importbuddy/controllers/pages/default.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgoKCi8qKioqKiogQkVHSU4gQVVUSEVOVElDQVRJT04gKioqKiovCi8vcmVxdWlyZV9vbmNlKCBBQlNQQVRIIC4gJ2ltcG9ydGJ1ZGR5L2NsYXNzZXMvYXV0aC5waHAnICk7CkF1dGg6OmNoZWNrKCk7CmlmICggKCB0cnVlID09PSBBdXRoOjppc19hdXRoZW50aWNhdGVkKCkgKSAmJiAoICdsb2dpbicgPT0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnYWN0aW9uJyApICkgKSB7IC8vIE9uIHN1Y2Nlc3NmdWwgbG9naW4gdG8gc3RlcCAwLCByZWRpcmVjdCB0byBzdGVwIDEuCgloZWFkZXIoICdMb2NhdGlvbjogJyAuIHBiX2JhY2t1cGJ1ZGR5OjpwYWdlX3VybCgpICk7Cn0KLyoqKioqKiBFTkQgQVVUSEVOVElDQVRJT04gKioqKiovCgoKCiRtb2RlID0gJ2h0bWwnOwoKCgovLyBSZWdpc3RlciBQSFAgc2h1dGRvd24gZnVuY3Rpb24gdG8gaGVscCBjYXRjaCBhbmQgbG9nIGZhdGFsIFBIUCBlcnJvcnMgZHVyaW5nIGJhY2t1cC4KcmVnaXN0ZXJfc2h1dGRvd25fZnVuY3Rpb24oICdzaHV0ZG93bl9mdW5jdGlvbicgKTsKLy9lcnJvcl9yZXBvcnRpbmcoIEVfRVJST1IgfCBFX1dBUk5JTkcgfCBFX1BBUlNFIHwgRV9OT1RJQ0UgKTsgLy8gSElHSAoKLyoJc2h1dGRvd25fZnVuY3Rpb24oKQogKgkKICoJVXNlZCBmb3IgY2F0Y2hpbmcgZmF0YWwgUEhQIGVycm9ycyBkdXJpbmcgYmFja3VwIHRvIHdyaXRlIHRvIGxvZyBmb3IgZGVidWdnaW5nLgogKgkKICoJQHJldHVybgkJbnVsbAogKi8KZnVuY3Rpb24gc2h1dGRvd25fZnVuY3Rpb24oKSB7CgkKCQoJLy8gR2V0IGVycm9yIG1lc3NhZ2UuCgkvLyBFcnJvciB0eXBlczogaHR0cDovL3BocC5uZXQvbWFudWFsL2VuL2Vycm9yZnVuYy5jb25zdGFudHMucGhwCgkkZSA9IGVycm9yX2dldF9sYXN0KCk7CglpZiAoICRlID09PSBOVUxMICkgeyAvLyBObyBlcnJvciBvZiBhbnkga2luZC4KCQlyZXR1cm47Cgl9IGVsc2UgeyAvLyBTb21lIHR5cGUgb2YgZXJyb3IuCgkJaWYgKCAhaXNfYXJyYXkoICRlICkgfHwgKCAkZVsndHlwZSddICE9IEVfRVJST1IgKSAmJiAoICRlWyd0eXBlJ10gIT0gRV9VU0VSX0VSUk9SICkgKSB7IC8vIFJldHVybiBpZiBub3QgYSBmYXRhbCBlcnJvci4KCQkJLy9lY2hvICc8IS0tICcgLiBwcmludF9yKCAkZSwgdHJ1ZSApIC4gJyAtLT4nIC4gIlxuIjsKCQkJcmV0dXJuOwoJCX0KCX0KCQoJCgkvLyBDYWxjdWxhdGUgbG9nIGRpcmVjdG9yeS4KCSRsb2dfZGlyZWN0b3J5ID0gYmFja3VwYnVkZHlfY29yZTo6Z2V0TG9nRGlyZWN0b3J5KCk7IC8vIEFsc28gaGFuZGxlIHdoZW4gaW4gaW1wb3J0YnVkZHkuCgkkbWFpbl9maWxlID0gJGxvZ19kaXJlY3RvcnkgLiAnbG9nLScgLiBwYl9iYWNrdXBidWRkeTo6JG9wdGlvbnNbJ2xvZ19zZXJpYWwnXSAuICcudHh0JzsKCQoJCgkvLyBEZXRlcm1pbmUgaWYgd3JpdGluZyB0byBhIHNlcmlhbCBsb2cuCglpZiAoIHBiX2JhY2t1cGJ1ZGR5OjokX3N0YXR1c19zZXJpYWwgIT0gJycgKSB7CgkJJHNlcmlhbCA9IHBiX2JhY2t1cGJ1ZGR5OjokX3N0YXR1c19zZXJpYWw7CgkJJHNlcmlhbF9maWxlID0gJGxvZ19kaXJlY3RvcnkgLiAnc3RhdHVzLScgLiAkc2VyaWFsIC4gJ18nIC4gcGJfYmFja3VwYnVkZHk6OiRvcHRpb25zWydsb2dfc2VyaWFsJ10gLiAnLnR4dCc7CgkJJHdyaXRlX3NlcmlhbCA9IHRydWU7Cgl9IGVsc2UgewoJCSR3cml0ZV9zZXJpYWwgPSBmYWxzZTsKCX0KCQoJCgkvLyBGb3JtYXQgZXJyb3IgbWVzc2FnZS4KCSRlX3N0cmluZyA9ICctLS0tLSBGQVRBTCBFUlJPUiAtLS0tLSBBIGZhdGFsIFBIUCBlcnJvciB3YXMgZW5jb3VudGVyZWQ6ICc7Cglmb3JlYWNoKCAoYXJyYXkpJGUgYXMgJGVfbGluZV90aXRsZSA9PiAkZV9saW5lICkgewoJCSRlX3N0cmluZyAuPSAkZV9saW5lX3RpdGxlIC4gJyA9PiAnIC4gJGVfbGluZSAuICI7ICI7Cgl9CgkkZV9zdHJpbmcgPSBydHJpbSggJGVfc3RyaW5nLCAnOyAnICkgLiAnLic7CgkKCS8vIFdyaXRlIHRvIGxvZy4KCUBmaWxlX3B1dF9jb250ZW50cyggJG1haW5fZmlsZSwgJGVfc3RyaW5nLCBGSUxFX0FQUEVORCApOwoJCgkvLyBJTVBPUlRCVUREWQoJJHN0YXR1cyA9IHBiX2JhY2t1cGJ1ZGR5OjokZm9ybWF0LT5kYXRlKCB0aW1lKCkgKSAuICJcdCIgLgoJCQkJc3ByaW50ZiggIiUwMS4yZiIsIHJvdW5kKCBtaWNyb3RpbWUoIHRydWUgKSAtIHBiX2JhY2t1cGJ1ZGR5Ojokc3RhcnRfdGltZSwgMiApICkgLiAiXHQiIC4KCQkJCXNwcmludGYoICIlMDEuMmYiLCByb3VuZCggbWVtb3J5X2dldF9wZWFrX3VzYWdlKCkgLyAxMDQ4NTc2LCAyICkgKSAuICJcdCIgLgoJCQkJJ2Vycm9yJyAuICJcdFx0IiAuCgkJCQlzdHJfcmVwbGFjZSggY2hyKDkpLCAnICAgJywgJGVfc3RyaW5nICkKCQkJOwoJJHN0YXR1cyA9IHN0cl9yZXBsYWNlKCAnXFwnLCAnLycsICRzdGF0dXMgKTsKCWVjaG8gJzxzY3JpcHQgdHlwZT0idGV4dC9qYXZhc2NyaXB0Ij5wYl9zdGF0dXNfYXBwZW5kKCInIC4gc3RyX3JlcGxhY2UoICciJywgJyZxdW90OycsICRzdGF0dXMgKSAuICciKTs8L3NjcmlwdD4nOwoJCn0gLy8gRW5kIHNodXRkb3duX2Z1bmN0aW9uLgoKCgoKLy8gSGFuZGxlIEFKQVguCgokYWpheCA9ICcnOwppZiAoIHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ2FqYXgnICkgIT0gJycgKSB7CgkkYWpheCA9IHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ2FqYXgnICk7Cn0gZWxzZWlmICggcGJfYmFja3VwYnVkZHk6Ol9HRVQoICdhamF4JyApICE9ICcnICkgewoJJGFqYXggPSBwYl9iYWNrdXBidWRkeTo6X0dFVCggJ2FqYXgnICk7Cn0KaWYgKCAkYWpheCAhPSAnJyApIHsgLy8gQUpBWAoJCglBdXRoOjpyZXF1aXJlX2F1dGhlbnRpY2F0aW9uKCk7IC8vIERpZSBpZiBub3QgbG9nZ2VkIGluLgoJCgkkcGFnZSA9IEFCU1BBVEggLiAnaW1wb3J0YnVkZHkvY29udHJvbGxlcnMvYWpheC8nIC4gJGFqYXggLiAnLnBocCc7CglpZiAoIGZpbGVfZXhpc3RzKCAkcGFnZSApICkgewoJCXJlcXVpcmVfb25jZSggJHBhZ2UgKTsKCX0gZWxzZSB7CgkJZWNobyAne0Vycm9yOiBJbnZhbGlkIEFKQVggYWN0aW9uIGAnIC4gaHRtbGVudGl0aWVzKCAkYWpheCApIC4gJ2AgRmlsZSBub3QgZm91bmQ6IGAnIC4gJHBhZ2UgLiAnYC59JzsKCX0KCXJldHVybjsKCQp9CgoKLy8gRGV0ZXJtaW5lIHBhZ2UgdG8gbG9hZC4KCmlmICggcGJfYmFja3VwYnVkZHk6Ol9HRVQoICdwYWdlJyApICE9ICcnICkgeyAvLyBOYW1lZCBwYWdlLgoJCglBdXRoOjpyZXF1aXJlX2F1dGhlbnRpY2F0aW9uKCk7IC8vIERpZSBpZiBub3QgbG9nZ2VkIGluLgoJCgkkcGFnZVNsdWcgPSBzdHJfcmVwbGFjZSggYXJyYXkoICdcXCcsICcvJyApLCAnJywgcGJfYmFja3VwYnVkZHk6Ol9HRVQoICdwYWdlJyApICk7CglpZiAoICEgY3R5cGVfYWxudW0oIHN0cl9yZXBsYWNlKCBhcnJheSggJy0nLCAnXycgKSwgJycsICRwYWdlU2x1ZyApICkgKSB7IC8vIERpc2FsbG93IG5vbi1hbHBoYW51bWVyaWMgZXhjZXB0IGRhc2gsIHVuZGVyc2NvcmUuCgkJZGllKCAnRXJyb3IgIzg1NzQ3ODMzLiBQYWdlIGNvbnRhaW5zIGRpc2FsbG93ZWQgY2hhcmFjdGVycy4gT25seSBhbHBoYW51bWVyaWMsIGRhc2hlcywgYW5kIHVuZGVyc2NvcmVzIHBlcm1pdHRlZC4nICk7Cgl9IAoJCgkkcGFnZUZpbGUgPSBBQlNQQVRIIC4gJ2ltcG9ydGJ1ZGR5L2NvbnRyb2xsZXJzL3BhZ2VzLycgLiAkcGFnZVNsdWcgLiAnLnBocCc7CglpZiAoIGZpbGVfZXhpc3RzKCAkcGFnZUZpbGUgKSApIHsKCQllY2hvICc8IS0tIFN0YXJ0aW5nIHBhZ2UgJyAuICRwYWdlU2x1ZyAuICcuIC0tPic7CgkJcmVxdWlyZV9vbmNlKCAkcGFnZUZpbGUgKTsKCQlwYl9iYWNrdXBidWRkeTo6c3RhdHVzKCAnZGV0YWlscycsICdGaW5pc2hlZCBwYWdlICcgLiAkcGFnZVNsdWcgLiAnLicgKTsKCX0gZWxzZSB7CgkJZWNobyAne0Vycm9yOiBJbnZhbGlkIHBhZ2UgYCcgLiBodG1sZW50aXRpZXMoIHBiX2JhY2t1cGJ1ZGR5OjpfR0VUKCAnc3RlcCcgKSApIC4gJy5waHAnIC4gJ2AufSc7Cgl9CglyZXR1cm47CgkKfSBlbHNlaWYgKCBwYl9iYWNrdXBidWRkeTo6X0dFVCggJ3N0ZXAnICkgIT0gJycgKSB7IC8vIE51bWVyaWNhbCBzdGVwLgoJCglpZiAoIHRydWUgIT09IEF1dGg6OmlzX2F1dGhlbnRpY2F0ZWQoKSApIHsgLy8gSWYgbm90IGxvZ2dlZCBpbiB0aGVuIHByb3ZpZGUgbG9naW4gcGFnZS4KCQkkc3RlcCA9ICdsb2dpbic7Cgl9IGVsc2UgewoJCSRzdGVwID0gcGJfYmFja3VwYnVkZHk6Ol9HRVQoICdzdGVwJyApOwoJCUF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCgl9CgkKfSBlbHNlIHsgLy8gVW5rbm93bi4gRGVmYXVsdCB0byBsb2dpbi4KCWlmICggdHJ1ZSAhPT0gQXV0aDo6aXNfYXV0aGVudGljYXRlZCgpICkgeyAvLyBJZiBub3QgbG9nZ2VkIGluIHRoZW4gcHJvdmlkZSBsb2dpbiBwYWdlLgoJCSRzdGVwID0gJ2xvZ2luJzsKCX0gZWxzZSB7CgkJJHN0ZXAgPSAnaG9tZUJhY2t1cFNlbGVjdCc7Cgl9Cn0KCiRzdGVwRmlsZSA9IEFCU1BBVEggLiAnaW1wb3J0YnVkZHkvY29udHJvbGxlcnMvcGFnZXMvJyAuICRzdGVwIC4gJy5waHAnOwokc3RlcCA9IHBiX2JhY2t1cGJ1ZGR5OjpfR0VUKCAnc3RlcCcgKTsKcmVxdWlyZV9vbmNlKCBBQlNQQVRIIC4gJ2ltcG9ydGJ1ZGR5L3ZpZXdzL19oZWFkZXIucGhwJyApOwplY2hvICc8IS0tIFN0YXJ0aW5nIHN0ZXAgZmlsZSBgJyAuIGJhc2VuYW1lKCAkc3RlcEZpbGUgKSAuICdgLiAtLT4nOwoKLyppZiAoICRzdGVwID4gMCApIHsgLy8gTG9hZCBzdGVwcyBhZnRlciAwIGluIGlmcmFtZS4KCWVjaG8gcGJfYmFja3VwYnVkZHk6OiRjbGFzc2VzWydpbXBvcnQnXS0+c3RhdHVzX2JveCggJ0ltcG9ydEJ1ZGR5IHYnIC4gcGJfYmFja3VwYnVkZHk6OiRvcHRpb25zWydiYl92ZXJzaW9uJ10gLiAnLi4uIFBvd2VyZWQgYnkgQmFja3VwQnVkZHkuJyApOwoJZWNobyAnPGlmcmFtZSBpZD0icGJfYmFja3VwYnVkZHlfbW9kYWxfaWZyYW1lIiBuYW1lPSJwYl9iYWNrdXBidWRkeV9tb2RhbF9pZnJhbWUiIHNyYz0iJyAuIHBiX2JhY2t1cGJ1ZGR5OjpwYWdlX3VybCgpIC4gJ2ltcG9ydGJ1ZGR5LnBocD9hamF4PScgLiAkc3RlcCAuICciIHdpZHRoPSIxMDAlIiBoZWlnaHQ9IjE4MDAiIGZyYW1lYm9yZGVyPSIwIiBwYWRkaW5nPSIwIiBtYXJnaW49IjAiPkVycm9yICM0NTg0NTk0NTc5LiBCcm93c2VyIG5vdCBjb21wYXRpYmxlIHdpdGggaWZyYW1lcy48L2lmcmFtZT4nOwp9IGVsc2UgewoJKi8KCWlmICggZmlsZV9leGlzdHMoICRzdGVwRmlsZSApICkgewoJCXJlcXVpcmVfb25jZSggJHN0ZXBGaWxlICk7Cgl9IGVsc2UgewoJCWVjaG8gJ3tFcnJvcjogSW52YWxpZCBzdGVwIGZpbGUgYCcgLiBodG1sZW50aXRpZXMoICRzdGVwICkgLiAnLnBocCcgLiAnYC59JzsKCX0KLy99CnBiX2JhY2t1cGJ1ZGR5OjpzdGF0dXMoICdkZXRhaWxzJywgJ0ZpbmlzaGVkIHN0ZXAuJyApOwpyZXF1aXJlX29uY2UoIEFCU1BBVEggLiAnaW1wb3J0YnVkZHkvdmlld3MvX2Zvb3Rlci5waHAnICk7CgpyZXR1cm47Cgo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/default.php,importbuddy/controllers/pages/default.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/homeBackupSelect.php,importbuddy/controllers/pages/homeBackupSelect.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/homeBackupSelect.php,importbuddy/controllers/pages/homeBackupSelect.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/index.php,importbuddy/controllers/pages/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/index.php,importbuddy/controllers/pages/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/login.php,importbuddy/controllers/pages/login.php
PD9waHAKJGRhdGEgPSBhcnJheSgpOwokZGF0YVsndGl0bGUnXSA9ICdBdXRoZW50aWNhdGlvbiBSZXF1aXJlZCc7CgoKcGJfYmFja3VwYnVkZHk6OmxvYWRfdmlldyggJ2xvZ2luJywgJGRhdGEgKTs=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/login.php,importbuddy/controllers/pages/login.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/server_tools.php,importbuddy/controllers/pages/server_tools.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/server_tools.php,importbuddy/controllers/pages/server_tools.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/serverinfo.php,importbuddy/controllers/pages/serverinfo.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CkF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCgpyZXF1aXJlX29uY2UoIEFCU1BBVEggLidpbXBvcnRidWRkeS92aWV3cy9faGVhZGVyLnBocCcgKTsKPz4KPHNjcmlwdD5qUXVlcnkoICcjcGFnZVRpdGxlJyApLmh0bWwoICdTZXJ2ZXIgSW5mb3JtYXRpb24nICk7PC9zY3JpcHQ+Cgo8ZGl2IGNsYXNzPSJ3cmFwIj4KCTw/cGhwCglnbG9iYWwgJGRldGVjdGVkX21heF9leGVjdXRpb25fdGltZTsKCXJlcXVpcmVfb25jZSggJ3NlcnZlcl90b29scy5waHAnICk7Cgk/Pgo8L2Rpdj4KCjw/cGhwCnJlcXVpcmVfb25jZSggQUJTUEFUSCAuJ2ltcG9ydGJ1ZGR5L3ZpZXdzL19mb290ZXIucGhwJyApOw==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/serverinfo.php,importbuddy/controllers/pages/serverinfo.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/lib/pclzip/index.php,importbuddy/lib/pclzip/index.php
PD9waHAgLy8gU2lsZW5jZSBpcyBnb2xkZW4u
###PACKDATA,FILE_END,/_importbuddy/importbuddy/lib/pclzip/index.php,importbuddy/lib/pclzip/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/lib/pclzip/pclzip.php,importbuddy/lib/pclzip/pclzip.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/lib/pclzip/pclzip.php,importbuddy/lib/pclzip/pclzip.php
###PACKDATA,FILE_START,/classes/_migrate_database.php,importbuddy/classes/_migrate_database.php
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