<?php 
/* 
Template Name: Blog Template
Single Post Template: Blog Template
Description: Shows the latest blog posts
*/

/* 
This file is part of HeatMap Theme Pro v5
Copyright: Stuart Wider
Website: HeatMapTheme.com
*/
?>
<?php get_header(); 

global $this_is_a_blog_page;
$this_is_a_blog_page = true;
?>



<!-- 
blog-template.php
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->
		
<!--
Content of the page (inc comments and post details)
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->
<div id="page-body-wrapper">

	<div id="content">
		
		<div class="post-content">
<!--
Widget Area: [All Content] Above 
~~~ -->	

			<?php 
            if (hmt_is_sidebar_active('sidebar-7')):
            ?>
				
                <div id="all-content-above">
				
                    <span class="all-content-above-widget-block">
                        <?php dynamic_sidebar('sidebar-7'); ?>
                    </span>
                
                </div> <!-- id="all-content-above" -->
            
            <?php
			endif;
			?>
			
			<?php $all_content_above_already_shown = TRUE;	// Set the ads above the content to 'already shown' so that common.php doesnt double up and show the ad again ?>

		
			<?php 			
			$temp = $wp_query;
			$wp_query= null;
			$wp_query = new WP_Query();
			$wp_query->query('paged='.$paged);

			if (have_posts()) : 
			?>

				<h2 class="h2-simulate-h1-size-underline"><?php _e('Latest Blog Posts','hmth') ?></h2>

			<?php else :

				echo("<h2 class='h2-simulate-h1-size'>" . _e('No posts found.','hmth') . "</h2>");
	
			endif; ?> 
		  
		</div> <!-- class="post-content" -->
		
		<?php 
		get_template_part("common"); 
		?>
        
<!--
Widget Area: [All Content] Below
~~~ -->
		<?php
        if (hmt_is_sidebar_active('sidebar-8')):
        ?>
            
            <div id="all-content-below">
            
                <span class="all-content-below-widget-block">
                    <?php dynamic_sidebar('sidebar-8'); ?>
                </span>
            
            </div> <!-- id="all-content-below" -->
        
        <?php
        endif;
        ?>     
        
        <div class="post-nav"><p><?php posts_nav_link(); ?></p></div>      
		
	</div> <!-- id="content" -->
	
	<?php 
	if (!hmt4_get_option('hmt_no_sidebars_mode')) { 
		get_sidebar(); 
	}
	?>
    
<!--
[Footer Above] Below
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

	<?php 
    if (hmt_is_sidebar_active('footer_above')):
    ?>

        <div id="footer-above">
            <ul class="footer-above-widget-block">
            	<?php dynamic_sidebar('footer_above'); ?> 
            </ul>
        </div> <!-- id="footer-above" -->
            
        <div class="clearFloat"></div>
    
    <?php 
    endif;
    ?>
	
</div> <!-- id="page-body-wrapper" -->

<?php get_footer(); ?>
	
	
<!--
End of blog-template.php
~~~ -->