<?php 
/* 
This file is part of HeatMap Theme Pro v5
Copyright: Stuart Wider
Website: HeatMapTheme.com
*/
?>

<?php get_header(); ?>

<!--
attachment.php
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>> 
		
<!--
Content of the page (inc comments and post details)
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->
	
    <div id="page-body-wrapper">
            
        <div id="content">
            
        <?php global $have_posts; ?>        
                    
        <?php
        if ($have_posts):
        ?>
        
        <?php $ids[0] = get_the_ID(); /* grabs the id of the page so it can be excluded in the recent posts plus widget */ ?>  
	
<!--
The Post
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->
	
			<div class="post-content">
	
<!--
Widget Area: [All Content] Above 
~~~ -->
				<?php 
                if (hmt_is_sidebar_active('sidebar-7')):
                ?>
                    
                    <div id="all-content-above">
                    
                        <span class="all-content-above-widget-block">
                            <?php dynamic_sidebar('sidebar-7'); ?>
                        </span>
                    
                    </div> <!-- id="all-content-above" -->
                
                <?php
                endif;
                ?>
	
<!--
The Post Title 
~~~ -->				
				<h1 class="h1-underline"><?php the_title(); ?></h1>
<!--
Widget Area: [Content Item] Above 
~~~ -->			
				<?php
                if (hmt_is_sidebar_active('sidebar-9')):
                ?>
                    
                    <div id="content-item-above">
                    
                        <span class="content-item-above-widget-block">
                            <?php dynamic_sidebar('sidebar-9'); ?>
                        </span>
                    
                    </div> <!-- id="content-item-above" -->
                
                <?php
                endif;
                ?>
<!--
The content itself 
~~~ -->
			
				<?php 	// get the attachment instead of the content
                if (wp_attachment_is_image($post->id)) {       
                    $att_image = wp_get_attachment_image_src( $post->id, "medium");
                ?>
                    <p class="attachment">
                        <a href="<?php echo wp_get_attachment_url($post->id); ?>" title="<?php the_title(); ?>">
                        <img src="<?php echo $att_image[0];?>" width="<?php echo $att_image[1];?>" height="<?php echo $att_image[2];?>"  class="attachment-medium" alt="<?php $post->post_excerpt; ?>" />
                        </a>
                    </p>
                <?php 
                } 
        
                edit_post_link(__('(Edit)','hmth'), '<p>', '</p>'); ?>
			
<!--
Pagination for Multi-page posts
~~~ -->
				<?php wp_link_pages('before=<p class="multi-page">' . __('Pages:','hmth') . '&after=</p>');  /* if this is a multipage post then show the navigation */ ?>
<!--
Widget Area: [Content Item] Below
~~~ -->
				<?php
                if (hmt_is_sidebar_active('sidebar-10')):
                ?>
                    <div id="content-item-below">
                        <span class="content-item-below-widget-block">
                            <?php dynamic_sidebar('sidebar-10'); ?>
                        </span>
                    </div> <!-- id="content-item-below" -->
                        
                    <div class="clearFloat"></div>
                <?php 
                endif;
                ?>
          
            </div> <!-- class="post-content" -->
        
            <div class="clearFloat"></div>
	
<!--
Post Details 
~~~ -->
<?php            

               $leave_out_details ="";
               $leave_out_comments="";
?>
			<?php if (hmt4_get_option('hmt_hide_details_for_posts')) $leave_out_details = true; ?>
            <?php if (hmt4_get_option('hmt_hide_comments_for_posts')) $leave_out_comments = true; ?>
    
            <?php 
            
            if (!$leave_out_details) { /* the logic here is reverse to what you think */ 
            ?> 
    
                <div class="post-details">
    
                    <p class="comment-button-box">
                    <?php 
                    if (($post->comment_status != 'closed')) { // if comments are not closed then show the comments button ?>
                        
                        <?php 
                        if (!$leave_out_comments) { ?>
                            <span class="comment-button"><a href="<?php the_permalink(); ?>#respond"><?php comments_number(__('Be the first to comment','hmth'), __('1 comment','hmth'), __('% comments','hmth'));?></a><?php if ('closed' != $post->comment_status) { print ' - '; _e('What do you think?','hmth'); }?></span><br /> 
                        <?php 
                        }
                    } else {
                    ?>	
                        <?php
                        $number_of_comments = get_comments_number();
                        if ($number_of_comments > 0) {
                        ?>
                            <?php 
                            if (!$leave_out_comments) { 
                            ?>
                                <span class="comment-button"><?php comments_number(__('No comments','hmth'),__('1 Comment','hmth'),__('% Comments','hmth'));?></span>&nbsp;<?php _e('[Comments are now closed for this post]','hmth'); ?><br />
                            <?php 
                            }
                        }
                    } 
                    ?>
                    
                    <?php if (!$leave_out_comments) { ?><?php _e('Posted by','hmth'); ?>
                        <?php echo get_the_author(); ?>
                        <?php /* the_author_posts_link(); */ /*uncomment this if you actually want a link to the authors posts - it reveals the authors username though - or am I being too security concious? */?>
                         - 
                        <?php the_date();?> <?php _e('at','hmth'); ?>  <?php the_time(); /* changed date and time format 19/10/09 so that default system date and time is used instead of preset date and time */ ?>
                    <?php }?>
                    </p>
                    
                
            
                    <p><?php _e('Categories','hmth') ?>:
                        <?php the_category(', ') ?>
                    &nbsp;<?php _e('Tags','hmth') ?>:
                        <?php the_tags('') ?>
                    </p>
            
                </div> <!-- class="post-details" -->
            
            <?php 
            } 
            else if (!$leave_out_comments) { /* logic so to allow only the comments # button to show as set in the Heatmap Admin  */ ?>
                    
                <?php 
                if (($post->comment_status != 'closed')) { // if comments are not closed then show the comments button ?>
                
                    <div class="post-details nobg">
                
                        <p class="comment-button-box"><span class="comment-button"><a href="<?php the_permalink(); ?>#respond"><?php comments_number(__('Be the first to comment','hmth'), __('1 comment','hmth'), __('% comments','hmth'));?></a><?php if ('closed' != $post->comment_status) { print ' - '; _e('What do you think?','hmth'); }?></span></p>
     
                    </div> <!-- class="post-details" -->
        
                <?php 
                } else { 
                ?>
                
                    <?php
                    $number_of_comments = get_comments_number();
                    if ($number_of_comments > 0) {
                    ?>
    
                    <div class="post-details nobg">
                                
                        <p class="comment-button-box"><span class="comment-button"><?php comments_number(__('No comments','hmth'), __('1 Comment','hmth'), __('% Comments','hmth'));?></span>&nbsp;<?php _e('[Comments are now closed for this post]','hmth'); ?></p>
                    
                    </div> <!-- class="post-details" -->
                    
                    <?php
                    }
                } 
            }
            ?> 
        
            <!--
            <?php trackback_rdf(); ?>
            -->
        
            <?php else: ?>
                <h2 class="h2-simulate-h1-size"><?php _e('No posts found','hmth') ?></h2>
            <?php endif; ?>
	

<!--
The comments
~~~ -->
			<?php 
            if ((!$leave_out_comments)||!$leave_out_details) { /* the logic here is reverse to what you think */ 
            ?>
        
                <div class="comment-item">
                    <?php comments_template('',true); ?>
                </div> <!-- class="comment-item" -->
            
            <?php 
            } 
            ?> 
	
<!--
Widget Area: [All Content] Below
~~~ -->
			<?php
            if (hmt_is_sidebar_active('sidebar-8')):
            ?>
                
                <div id="all-content-below">
                
                    <span class="all-content-below-widget-block">
                        <?php dynamic_sidebar('sidebar-8'); ?>
                    </span>
                
                </div> <!-- id="all-content-below" -->
            
            <?php
            endif;
            ?>
    
            
        </div> <!-- id="content" -->
    
   <!-- </div>--> <!-- post_class -->  
	
	<?php 
	if (!hmt4_get_option('hmt_no_sidebars_mode')) { 
		get_sidebar(); 
	}
	?>

<!--
[Footer Above] Below
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

	<?php 
    if (hmt_is_sidebar_active('footer_above')):
    ?>

        <div id="footer-above">
            <ul class="footer-above-widget-block">
            	<?php dynamic_sidebar('footer_above'); ?> 
            </ul>
        </div> <!-- id="footer-above" -->
            
        <div class="clearFloat"></div>
    
    <?php 
    endif;
    ?>

  </div> <!-- id="page-body-wrapper" -->
</div> <!-- end of  id="post... -->

<?php get_footer(); ?>
	


<!--
End of attachment.php 
~~~ -->
